/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.jaxrs.provider;

import com.google.common.io.BaseEncoding;
import io.getlime.powerauth.soap.PowerAuthPortServiceStub;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.http.PowerAuthTokenHttpHeader;
import io.getlime.security.powerauth.http.validator.InvalidPowerAuthHttpHeaderException;
import io.getlime.security.powerauth.http.validator.PowerAuthSignatureHttpHeaderValidator;
import io.getlime.security.powerauth.http.validator.PowerAuthTokenHttpHeaderValidator;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthAuthentication;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthSignatureAuthentication;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthTokenAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.provider.PowerAuthAuthenticationProviderBase;
import io.getlime.security.powerauth.rest.api.jaxrs.authentication.PowerAuthApiAuthenticationImpl;
import io.getlime.security.powerauth.rest.api.jaxrs.authentication.PowerAuthSignatureAuthenticationImpl;
import io.getlime.security.powerauth.rest.api.jaxrs.authentication.PowerAuthTokenAuthenticationImpl;
import io.getlime.security.powerauth.rest.api.jaxrs.converter.SignatureTypeConverter;
import io.getlime.security.powerauth.soap.axis.client.PowerAuthServiceClient;
import java.rmi.RemoteException;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;

@Stateless
public class PowerAuthAuthenticationProvider
extends PowerAuthAuthenticationProviderBase {
    @Inject
    private PowerAuthServiceClient powerAuthClient;

    public PowerAuthApiAuthentication authenticate(PowerAuthAuthentication authentication) throws RemoteException {
        if (authentication instanceof PowerAuthSignatureAuthentication) {
            return this.validateSignatureAuthentication((PowerAuthSignatureAuthentication)authentication);
        }
        if (authentication instanceof PowerAuthTokenAuthentication) {
            return this.validateTokenAuthentication((PowerAuthTokenAuthentication)authentication);
        }
        return null;
    }

    private PowerAuthApiAuthentication validateSignatureAuthentication(PowerAuthSignatureAuthentication authentication) throws RemoteException {
        if (authentication.getSignatureType() != null) {
            SignatureTypeConverter converter = new SignatureTypeConverter();
            PowerAuthPortServiceStub.SignatureType signatureType = converter.convertFrom(authentication.getSignatureType());
            PowerAuthPortServiceStub.VerifySignatureRequest soapRequest = new PowerAuthPortServiceStub.VerifySignatureRequest();
            soapRequest.setActivationId(authentication.getActivationId());
            soapRequest.setApplicationKey(authentication.getApplicationKey());
            soapRequest.setSignature(authentication.getSignature());
            soapRequest.setSignatureType(signatureType);
            soapRequest.setData(PowerAuthHttpBody.getSignatureBaseString((String)authentication.getHttpMethod(), (String)authentication.getRequestUri(), (byte[])authentication.getNonce(), (byte[])authentication.getData()));
            PowerAuthPortServiceStub.VerifySignatureResponse soapResponse = this.powerAuthClient.verifySignature(soapRequest);
            if (soapResponse.getSignatureValid()) {
                PowerAuthApiAuthenticationImpl apiAuthentication = new PowerAuthApiAuthenticationImpl();
                apiAuthentication.setActivationId(soapResponse.getActivationId());
                apiAuthentication.setUserId(soapResponse.getUserId());
                apiAuthentication.setApplicationId(soapResponse.getApplicationId());
                apiAuthentication.setSignatureFactors(PowerAuthSignatureTypes.getEnumFromString((String)soapResponse.getSignatureType().getValue()));
                return apiAuthentication;
            }
            return null;
        }
        return null;
    }

    private PowerAuthApiAuthentication validateTokenAuthentication(PowerAuthTokenAuthentication authentication) throws RemoteException {
        PowerAuthPortServiceStub.ValidateTokenRequest soapRequest = new PowerAuthPortServiceStub.ValidateTokenRequest();
        soapRequest.setTokenId(authentication.getTokenId());
        soapRequest.setTokenDigest(authentication.getTokenDigest());
        soapRequest.setNonce(authentication.getNonce());
        soapRequest.setTimestamp(Long.valueOf(authentication.getTimestamp()).longValue());
        PowerAuthPortServiceStub.ValidateTokenResponse soapResponse = this.powerAuthClient.validateToken(soapRequest);
        if (soapResponse.getTokenValid()) {
            return this.copyAuthenticationAttributes(soapResponse.getActivationId(), soapResponse.getUserId(), soapResponse.getApplicationId(), PowerAuthSignatureTypes.getEnumFromString((String)soapResponse.getSignatureType().getValue()));
        }
        return null;
    }

    private PowerAuthApiAuthentication copyAuthenticationAttributes(String activationId, String userId, Long applicationId, PowerAuthSignatureTypes signatureType) {
        PowerAuthApiAuthenticationImpl apiAuthentication = new PowerAuthApiAuthenticationImpl();
        apiAuthentication.setActivationId(activationId);
        apiAuthentication.setUserId(userId);
        apiAuthentication.setApplicationId(applicationId);
        apiAuthentication.setSignatureFactors(signatureType);
        return apiAuthentication;
    }

    public PowerAuthApiAuthentication validateRequestSignature(String httpMethod, byte[] httpBody, String requestUriIdentifier, String httpAuthorizationHeader, List<PowerAuthSignatureTypes> allowedSignatureTypes) throws PowerAuthAuthenticationException {
        PowerAuthApiAuthentication auth;
        if (httpAuthorizationHeader == null || httpAuthorizationHeader.equals("undefined")) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_SIGNATURE_INVALID_EMPTY");
        }
        PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader().fromValue(httpAuthorizationHeader);
        try {
            PowerAuthSignatureHttpHeaderValidator.validate((PowerAuthSignatureHttpHeader)header);
        }
        catch (InvalidPowerAuthHttpHeaderException e) {
            throw new PowerAuthAuthenticationException(e.getMessage());
        }
        PowerAuthSignatureTypes expectedSignatureType = PowerAuthSignatureTypes.getEnumFromString((String)header.getSignatureType());
        if (!allowedSignatureTypes.contains(expectedSignatureType)) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_SIGNATURE_TYPE_INVALID");
        }
        PowerAuthSignatureAuthenticationImpl powerAuthAuthentication = new PowerAuthSignatureAuthenticationImpl();
        powerAuthAuthentication.setActivationId(header.getActivationId());
        powerAuthAuthentication.setApplicationKey(header.getApplicationKey());
        powerAuthAuthentication.setNonce(BaseEncoding.base64().decode((CharSequence)header.getNonce()));
        powerAuthAuthentication.setSignatureType(header.getSignatureType());
        powerAuthAuthentication.setSignature(header.getSignature());
        powerAuthAuthentication.setHttpMethod(httpMethod);
        powerAuthAuthentication.setRequestUri(requestUriIdentifier);
        powerAuthAuthentication.setData(httpBody);
        try {
            auth = this.authenticate((PowerAuthAuthentication)powerAuthAuthentication);
        }
        catch (RemoteException e) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_SIGNATURE_SOAP_ERROR");
        }
        if (auth == null) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_SIGNATURE_INVALID_VALUE");
        }
        return auth;
    }

    public PowerAuthApiAuthentication validateToken(String tokenHeader, List<PowerAuthSignatureTypes> allowedSignatureTypes) throws PowerAuthAuthenticationException {
        PowerAuthApiAuthentication auth;
        if (tokenHeader == null || tokenHeader.equals("undefined")) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_TOKEN_INVALID_EMPTY");
        }
        PowerAuthTokenHttpHeader header = new PowerAuthTokenHttpHeader().fromValue(tokenHeader);
        try {
            PowerAuthTokenHttpHeaderValidator.validate((PowerAuthTokenHttpHeader)header);
        }
        catch (InvalidPowerAuthHttpHeaderException e) {
            throw new PowerAuthAuthenticationException(e.getMessage());
        }
        PowerAuthTokenAuthenticationImpl powerAuthTokenAuthentication = new PowerAuthTokenAuthenticationImpl();
        powerAuthTokenAuthentication.setTokenId(header.getTokenId());
        powerAuthTokenAuthentication.setTokenDigest(header.getTokenDigest());
        powerAuthTokenAuthentication.setNonce(header.getNonce());
        powerAuthTokenAuthentication.setTimestamp(header.getTimestamp());
        try {
            auth = this.authenticate((PowerAuthAuthentication)powerAuthTokenAuthentication);
        }
        catch (RemoteException e) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_TOKEN_SOAP_ERROR");
        }
        if (auth == null) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_TOKEN_INVALID_VALUE");
        }
        PowerAuthSignatureTypes expectedSignatureType = auth.getSignatureFactors();
        if (!allowedSignatureTypes.contains(expectedSignatureType)) {
            throw new PowerAuthAuthenticationException("POWER_AUTH_TOKEN_SIGNATURE_TYPE_INVALID");
        }
        return auth;
    }
}

