/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.jaxrs.encryption;

import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.powerauth.soap.PowerAuthPortServiceStub;
import io.getlime.security.powerauth.rest.api.base.encryption.PowerAuthNonPersonalizedEncryptor;
import io.getlime.security.powerauth.rest.api.model.entity.NonPersonalizedEncryptedPayloadModel;
import io.getlime.security.powerauth.soap.axis.client.PowerAuthServiceClient;
import java.rmi.RemoteException;
import javax.ejb.Stateless;
import javax.inject.Inject;

@Stateless
public class EncryptorFactory {
    @Inject
    private PowerAuthServiceClient powerAuthClient;

    public PowerAuthNonPersonalizedEncryptor buildNonPersonalizedEncryptor(ObjectRequest<NonPersonalizedEncryptedPayloadModel> object) throws RemoteException {
        return this.buildNonPersonalizedEncryptor(((NonPersonalizedEncryptedPayloadModel)object.getRequestObject()).getApplicationKey(), ((NonPersonalizedEncryptedPayloadModel)object.getRequestObject()).getSessionIndex(), ((NonPersonalizedEncryptedPayloadModel)object.getRequestObject()).getEphemeralPublicKey());
    }

    public PowerAuthNonPersonalizedEncryptor buildNonPersonalizedEncryptor(String applicationKeyBase64, String sessionIndexBase64, String ephemeralPublicKeyBase64) throws RemoteException {
        PowerAuthPortServiceStub.GetNonPersonalizedEncryptionKeyResponse encryptionKeyResponse = this.powerAuthClient.generateNonPersonalizedE2EEncryptionKey(applicationKeyBase64, ephemeralPublicKeyBase64, sessionIndexBase64);
        return new PowerAuthNonPersonalizedEncryptor(encryptionKeyResponse.getApplicationKey(), encryptionKeyResponse.getEncryptionKey(), encryptionKeyResponse.getEncryptionKeyIndex(), encryptionKeyResponse.getEphemeralPublicKey());
    }
}

