/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.jaxrs.converter;

import io.getlime.powerauth.soap.PowerAuthPortServiceStub;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;

public class SignatureTypeConverter {
    public PowerAuthPortServiceStub.SignatureType convertFrom(String signatureTypeString) {
        if (signatureTypeString == null) {
            return PowerAuthPortServiceStub.SignatureType.POSSESSION_KNOWLEDGE_BIOMETRY;
        }
        try {
            signatureTypeString = signatureTypeString.toUpperCase();
            return PowerAuthPortServiceStub.SignatureType.Factory.fromValue((String)signatureTypeString);
        }
        catch (IllegalArgumentException e) {
            return PowerAuthPortServiceStub.SignatureType.POSSESSION_KNOWLEDGE_BIOMETRY;
        }
    }

    public PowerAuthPortServiceStub.SignatureType convertFrom(PowerAuthSignatureTypes powerAuthSignatureTypes) {
        switch (powerAuthSignatureTypes) {
            case POSSESSION: {
                return PowerAuthPortServiceStub.SignatureType.POSSESSION;
            }
            case KNOWLEDGE: {
                return PowerAuthPortServiceStub.SignatureType.KNOWLEDGE;
            }
            case BIOMETRY: {
                return PowerAuthPortServiceStub.SignatureType.BIOMETRY;
            }
            case POSSESSION_KNOWLEDGE: {
                return PowerAuthPortServiceStub.SignatureType.POSSESSION_KNOWLEDGE;
            }
            case POSSESSION_BIOMETRY: {
                return PowerAuthPortServiceStub.SignatureType.POSSESSION_BIOMETRY;
            }
        }
        return PowerAuthPortServiceStub.SignatureType.POSSESSION_KNOWLEDGE_BIOMETRY;
    }
}

