/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.jaxrs.controller;

import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.powerauth.soap.PowerAuthPortServiceStub;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.jaxrs.converter.SignatureTypeConverter;
import io.getlime.security.powerauth.rest.api.jaxrs.provider.PowerAuthAuthenticationProvider;
import io.getlime.security.powerauth.rest.api.model.request.TokenCreateRequest;
import io.getlime.security.powerauth.rest.api.model.request.TokenRemoveRequest;
import io.getlime.security.powerauth.rest.api.model.response.TokenCreateResponse;
import io.getlime.security.powerauth.rest.api.model.response.TokenRemoveResponse;
import io.getlime.security.powerauth.soap.axis.client.PowerAuthServiceClient;
import java.rmi.RemoteException;
import java.util.Arrays;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;

@Path(value="pa/token")
@Produces(value={"application/json"})
public class TokenController {
    @Inject
    private PowerAuthServiceClient powerAuthClient;
    @Inject
    private PowerAuthAuthenticationProvider authenticationProvider;
    @Context
    private HttpServletRequest httpServletRequest;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="create")
    public ObjectResponse<TokenCreateResponse> createToken(ObjectRequest<TokenCreateRequest> request, @HeaderParam(value="X-PowerAuth-Token") String tokenHeader) throws RemoteException, PowerAuthAuthenticationException {
        try {
            PowerAuthApiAuthentication authentication = this.authenticationProvider.validateToken(tokenHeader, Arrays.asList(PowerAuthSignatureTypes.POSSESSION, PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE, PowerAuthSignatureTypes.POSSESSION_BIOMETRY, PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE_BIOMETRY));
            if (authentication != null && authentication.getActivationId() != null) {
                String activationId = authentication.getActivationId();
                PowerAuthSignatureTypes signatureFactors = authentication.getSignatureFactors();
                TokenCreateRequest requestObject = (TokenCreateRequest)request.getRequestObject();
                String ephemeralPublicKey = requestObject.getEphemeralPublicKey();
                SignatureTypeConverter converter = new SignatureTypeConverter();
                PowerAuthPortServiceStub.CreateTokenResponse token = this.powerAuthClient.createToken(activationId, ephemeralPublicKey, converter.convertFrom(signatureFactors));
                TokenCreateResponse responseObject = new TokenCreateResponse();
                responseObject.setMac(token.getMac());
                responseObject.setEncryptedData(token.getEncryptedData());
                return new ObjectResponse((Object)responseObject);
            }
            throw new PowerAuthAuthenticationException();
        }
        catch (PowerAuthAuthenticationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PowerAuthAuthenticationException(ex.getMessage());
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="remove")
    public ObjectResponse<TokenRemoveResponse> removeToken(ObjectRequest<TokenRemoveRequest> request, @HeaderParam(value="X-PowerAuth-Token") String tokenHeader) throws RemoteException, PowerAuthAuthenticationException {
        try {
            PowerAuthApiAuthentication authentication = this.authenticationProvider.validateToken(tokenHeader, Arrays.asList(PowerAuthSignatureTypes.POSSESSION, PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE, PowerAuthSignatureTypes.POSSESSION_BIOMETRY, PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE_BIOMETRY));
            if (authentication != null && authentication.getActivationId() != null) {
                String activationId = authentication.getActivationId();
                TokenRemoveRequest requestObject = (TokenRemoveRequest)request.getRequestObject();
                String tokenId = requestObject.getTokenId();
                this.powerAuthClient.removeToken(tokenId, activationId);
                TokenRemoveResponse responseObject = new TokenRemoveResponse();
                responseObject.setTokenId(requestObject.getTokenId());
                return new ObjectResponse((Object)responseObject);
            }
            throw new PowerAuthAuthenticationException();
        }
        catch (PowerAuthAuthenticationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PowerAuthAuthenticationException(ex.getMessage());
        }
    }
}

