/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.jaxrs.controller;

import com.google.common.io.BaseEncoding;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.powerauth.soap.PowerAuthPortServiceStub;
import io.getlime.security.powerauth.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.http.validator.InvalidPowerAuthHttpHeaderException;
import io.getlime.security.powerauth.http.validator.PowerAuthSignatureHttpHeaderValidator;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthSecureVaultException;
import io.getlime.security.powerauth.rest.api.jaxrs.converter.SignatureTypeConverter;
import io.getlime.security.powerauth.rest.api.model.response.VaultUnlockResponse;
import io.getlime.security.powerauth.soap.axis.client.PowerAuthServiceClient;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="pa/vault")
@Produces(value={"application/json"})
public class SecureVaultController {
    @Inject
    private PowerAuthServiceClient powerAuthClient;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="unlock")
    public ObjectResponse<VaultUnlockResponse> unlockVault(@HeaderParam(value="X-PowerAuth-Authorization") String signatureHeader) throws PowerAuthAuthenticationException, PowerAuthSecureVaultException {
        try {
            PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader().fromValue(signatureHeader);
            try {
                PowerAuthSignatureHttpHeaderValidator.validate((PowerAuthSignatureHttpHeader)header);
            }
            catch (InvalidPowerAuthHttpHeaderException e) {
                throw new PowerAuthAuthenticationException(e.getMessage());
            }
            SignatureTypeConverter converter = new SignatureTypeConverter();
            String activationId = header.getActivationId();
            String applicationId = header.getApplicationKey();
            String signature = header.getSignature();
            PowerAuthPortServiceStub.SignatureType signatureType = converter.convertFrom(header.getSignatureType());
            String nonce = header.getNonce();
            String data = PowerAuthHttpBody.getSignatureBaseString((String)"POST", (String)"/pa/vault/unlock", (byte[])BaseEncoding.base64().decode((CharSequence)nonce), null);
            PowerAuthPortServiceStub.VaultUnlockResponse soapResponse = this.powerAuthClient.unlockVault(activationId, applicationId, data, signature, signatureType);
            if (!soapResponse.getSignatureValid()) {
                throw new PowerAuthAuthenticationException();
            }
            VaultUnlockResponse response = new VaultUnlockResponse();
            response.setActivationId(soapResponse.getActivationId());
            response.setEncryptedVaultEncryptionKey(soapResponse.getEncryptedVaultEncryptionKey());
            return new ObjectResponse((Object)response);
        }
        catch (PowerAuthAuthenticationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PowerAuthSecureVaultException();
        }
    }
}

