/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.jaxrs.controller;

import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.powerauth.soap.PowerAuthPortServiceStub;
import io.getlime.security.powerauth.rest.api.base.application.PowerAuthApplicationConfiguration;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthActivationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.jaxrs.provider.PowerAuthAuthenticationProvider;
import io.getlime.security.powerauth.rest.api.model.request.ActivationCreateRequest;
import io.getlime.security.powerauth.rest.api.model.request.ActivationStatusRequest;
import io.getlime.security.powerauth.rest.api.model.response.ActivationCreateResponse;
import io.getlime.security.powerauth.rest.api.model.response.ActivationRemoveResponse;
import io.getlime.security.powerauth.rest.api.model.response.ActivationStatusResponse;
import io.getlime.security.powerauth.soap.axis.client.PowerAuthServiceClient;
import java.rmi.RemoteException;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="pa/activation")
@Produces(value={"application/json"})
public class ActivationController {
    @Inject
    private PowerAuthServiceClient powerAuthClient;
    @Inject
    private PowerAuthAuthenticationProvider authenticationProvider;
    @Inject
    private PowerAuthApplicationConfiguration applicationConfiguration;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="create")
    public ObjectResponse<ActivationCreateResponse> createActivation(ObjectRequest<ActivationCreateRequest> request) throws RemoteException, PowerAuthActivationException {
        if (request.getRequestObject() == null) {
            throw new PowerAuthActivationException();
        }
        try {
            String activationIDShort = ((ActivationCreateRequest)request.getRequestObject()).getActivationIdShort();
            String activationNonce = ((ActivationCreateRequest)request.getRequestObject()).getActivationNonce();
            String cDevicePublicKey = ((ActivationCreateRequest)request.getRequestObject()).getEncryptedDevicePublicKey();
            String activationName = ((ActivationCreateRequest)request.getRequestObject()).getActivationName();
            String extras = ((ActivationCreateRequest)request.getRequestObject()).getExtras();
            String applicationKey = ((ActivationCreateRequest)request.getRequestObject()).getApplicationKey();
            String applicationSignature = ((ActivationCreateRequest)request.getRequestObject()).getApplicationSignature();
            String clientEphemeralKey = ((ActivationCreateRequest)request.getRequestObject()).getEphemeralPublicKey();
            PowerAuthPortServiceStub.PrepareActivationResponse soapResponse = this.powerAuthClient.prepareActivation(activationIDShort, activationName, activationNonce, clientEphemeralKey, cDevicePublicKey, extras, applicationKey, applicationSignature);
            ActivationCreateResponse response = new ActivationCreateResponse();
            response.setActivationId(soapResponse.getActivationId());
            response.setActivationNonce(soapResponse.getActivationNonce());
            response.setEncryptedServerPublicKey(soapResponse.getEncryptedServerPublicKey());
            response.setEncryptedServerPublicKeySignature(soapResponse.getEncryptedServerPublicKeySignature());
            response.setEphemeralPublicKey(soapResponse.getEphemeralPublicKey());
            return new ObjectResponse((Object)response);
        }
        catch (Exception e) {
            throw new PowerAuthActivationException();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="status")
    public ObjectResponse<ActivationStatusResponse> getActivationStatus(ObjectRequest<ActivationStatusRequest> request) throws RemoteException, PowerAuthActivationException {
        if (request.getRequestObject() == null) {
            throw new PowerAuthActivationException();
        }
        try {
            String activationId = ((ActivationStatusRequest)request.getRequestObject()).getActivationId();
            PowerAuthPortServiceStub.GetActivationStatusResponse soapResponse = this.powerAuthClient.getActivationStatus(activationId);
            ActivationStatusResponse response = new ActivationStatusResponse();
            response.setActivationId(soapResponse.getActivationId());
            response.setEncryptedStatusBlob(soapResponse.getEncryptedStatusBlob());
            if (this.applicationConfiguration != null) {
                response.setCustomObject(this.applicationConfiguration.statusServiceCustomObject());
            }
            return new ObjectResponse((Object)response);
        }
        catch (Exception e) {
            throw new PowerAuthActivationException();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="remove")
    public ObjectResponse<ActivationRemoveResponse> removeActivation(@HeaderParam(value="X-PowerAuth-Authorization") String signatureHeader) throws PowerAuthAuthenticationException, PowerAuthActivationException {
        try {
            PowerAuthApiAuthentication apiAuthentication = this.authenticationProvider.validateRequestSignature("POST", null, "/pa/activation/remove", signatureHeader);
            if (apiAuthentication != null && apiAuthentication.getActivationId() != null) {
                PowerAuthPortServiceStub.RemoveActivationResponse soapResponse = this.powerAuthClient.removeActivation(apiAuthentication.getActivationId());
                ActivationRemoveResponse response = new ActivationRemoveResponse();
                response.setActivationId(soapResponse.getActivationId());
                return new ObjectResponse((Object)response);
            }
            throw new PowerAuthAuthenticationException("USER_NOT_AUTHENTICATED");
        }
        catch (PowerAuthAuthenticationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PowerAuthActivationException();
        }
    }
}

