/*
 * Decompiled with CFR 0.152.
 */
package com.wultra.security.powerauth.rest.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.wultra.core.rest.client.base.DefaultRestClient;
import com.wultra.core.rest.client.base.RestClient;
import com.wultra.core.rest.client.base.RestClientException;
import com.wultra.security.powerauth.fido2.client.PowerAuthFido2Client;
import com.wultra.security.powerauth.fido2.model.entity.AuthenticatorAssertionResponse;
import com.wultra.security.powerauth.fido2.model.entity.AuthenticatorParameters;
import com.wultra.security.powerauth.fido2.model.error.PowerAuthError;
import com.wultra.security.powerauth.fido2.model.error.PowerAuthFido2Exception;
import com.wultra.security.powerauth.fido2.model.request.AssertionChallengeRequest;
import com.wultra.security.powerauth.fido2.model.request.AssertionVerificationRequest;
import com.wultra.security.powerauth.fido2.model.request.RegisteredAuthenticatorsRequest;
import com.wultra.security.powerauth.fido2.model.request.RegistrationChallengeRequest;
import com.wultra.security.powerauth.fido2.model.request.RegistrationRequest;
import com.wultra.security.powerauth.fido2.model.response.AssertionChallengeResponse;
import com.wultra.security.powerauth.fido2.model.response.AssertionVerificationResponse;
import com.wultra.security.powerauth.fido2.model.response.RegisteredAuthenticatorsResponse;
import com.wultra.security.powerauth.fido2.model.response.RegistrationChallengeResponse;
import com.wultra.security.powerauth.fido2.model.response.RegistrationResponse;
import com.wultra.security.powerauth.rest.client.PowerAuthFido2RestClientConfiguration;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class PowerAuthFido2RestClient
implements PowerAuthFido2Client {
    private static final Logger logger = LoggerFactory.getLogger(PowerAuthFido2RestClient.class);
    private static final String PA_REST_FIDO2_PREFIX = "/fido2";
    private static final MultiValueMap<String, String> EMPTY_MULTI_MAP = new LinkedMultiValueMap();
    private final RestClient restClient;
    private final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public PowerAuthFido2RestClient(String baseUrl) throws PowerAuthFido2Exception {
        this(baseUrl, new PowerAuthFido2RestClientConfiguration());
    }

    public PowerAuthFido2RestClient(String baseUrl, PowerAuthFido2RestClientConfiguration config) throws PowerAuthFido2Exception {
        DefaultRestClient.Builder builder = DefaultRestClient.builder().baseUrl(baseUrl).acceptInvalidCertificate(config.isAcceptInvalidSslCertificate()).connectionTimeout(config.getConnectTimeout()).responseTimeout(config.getResponseTimeout()).maxIdleTime(config.getMaxIdleTime()).maxLifeTime(config.getMaxLifeTime()).maxInMemorySize(Integer.valueOf(config.getMaxMemorySize()));
        if (config.isProxyEnabled()) {
            DefaultRestClient.ProxyBuilder proxyBuilder = builder.proxy().host(config.getProxyHost()).port(config.getProxyPort());
            if (config.getProxyUsername() != null) {
                proxyBuilder.username(config.getProxyUsername()).password(config.getProxyPassword());
            }
        }
        if (config.getPowerAuthClientToken() != null) {
            builder.httpBasicAuth().username(config.getPowerAuthClientToken()).password(config.getPowerAuthClientSecret());
        }
        if (config.getDefaultHttpHeaders() != null) {
            builder.defaultHttpHeaders(config.getDefaultHttpHeaders());
        }
        if (config.getFilter() != null) {
            builder.filter(config.getFilter());
        }
        try {
            this.restClient = builder.build();
        }
        catch (RestClientException ex) {
            throw new PowerAuthFido2Exception("REST client initialization failed, error: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private <T> T callFido2RestApi(String path, Object request, MultiValueMap<String, String> queryParams, MultiValueMap<String, String> httpHeaders, Class<T> responseType) throws PowerAuthFido2Exception {
        ObjectRequest objectRequest = new ObjectRequest(request);
        try {
            ObjectResponse objectResponse = this.restClient.postObject(PA_REST_FIDO2_PREFIX + path, objectRequest, queryParams, httpHeaders, responseType);
            return (T)objectResponse.getResponseObject();
        }
        catch (RestClientException ex) {
            if (ex.getStatusCode() == null) {
                logger.warn("PowerAuth FIDO2 service is not accessible, error: {}", (Object)ex.getMessage());
                logger.debug(ex.getMessage(), (Throwable)ex);
            } else if (ex.getStatusCode() == HttpStatus.NOT_FOUND) {
                logger.warn("PowerAuth FIDO2 service is not available, error: {}", (Object)ex.getMessage());
                logger.debug(ex.getMessage(), (Throwable)ex);
            } else if (ex.getStatusCode() == HttpStatus.BAD_REQUEST) {
                this.handleBadRequestError(ex);
            }
            throw new PowerAuthFido2Exception(ex.getMessage(), (Throwable)ex);
        }
    }

    private void handleBadRequestError(RestClientException ex) throws PowerAuthFido2Exception {
        try {
            TypeReference<ObjectResponse<PowerAuthError>> typeReference = new TypeReference<ObjectResponse<PowerAuthError>>(){};
            ObjectResponse error = (ObjectResponse)this.objectMapper.readValue(ex.getResponse(), (TypeReference)typeReference);
            if (error == null || error.getResponseObject() == null) {
                throw new PowerAuthFido2Exception("Invalid response object");
            }
            throw new PowerAuthFido2Exception(((PowerAuthError)error.getResponseObject()).getMessage(), (Throwable)ex, (PowerAuthError)error.getResponseObject());
        }
        catch (IOException ex2) {
            throw new PowerAuthFido2Exception(ex.getMessage(), (Throwable)ex);
        }
    }

    public RegisteredAuthenticatorsResponse getRegisteredAuthenticatorList(RegisteredAuthenticatorsRequest request) throws PowerAuthFido2Exception {
        return this.callFido2RestApi("/registrations/list", request, EMPTY_MULTI_MAP, EMPTY_MULTI_MAP, RegisteredAuthenticatorsResponse.class);
    }

    public RegisteredAuthenticatorsResponse getRegisteredAuthenticatorList(RegisteredAuthenticatorsRequest request, MultiValueMap<String, String> queryParams, MultiValueMap<String, String> httpHeaders) throws PowerAuthFido2Exception {
        return this.callFido2RestApi("/registrations/list", request, queryParams, httpHeaders, RegisteredAuthenticatorsResponse.class);
    }

    public RegisteredAuthenticatorsResponse getRegisteredAuthenticatorList(String userId, String applicationId) throws PowerAuthFido2Exception {
        RegisteredAuthenticatorsRequest request = new RegisteredAuthenticatorsRequest();
        request.setUserId(userId);
        request.setApplicationId(applicationId);
        return this.callFido2RestApi("/registrations/list", request, EMPTY_MULTI_MAP, EMPTY_MULTI_MAP, RegisteredAuthenticatorsResponse.class);
    }

    public RegistrationChallengeResponse requestRegistrationChallenge(RegistrationChallengeRequest request) throws PowerAuthFido2Exception {
        return this.callFido2RestApi("/registrations/challenge", request, EMPTY_MULTI_MAP, EMPTY_MULTI_MAP, RegistrationChallengeResponse.class);
    }

    public RegistrationChallengeResponse requestRegistrationChallenge(RegistrationChallengeRequest request, MultiValueMap<String, String> queryParams, MultiValueMap<String, String> httpHeaders) throws PowerAuthFido2Exception {
        return this.callFido2RestApi("/registrations/challenge", request, queryParams, httpHeaders, RegistrationChallengeResponse.class);
    }

    public RegistrationChallengeResponse requestRegistrationChallenge(String userId, String applicationId) throws PowerAuthFido2Exception {
        RegistrationChallengeRequest request = new RegistrationChallengeRequest();
        request.setUserId(userId);
        request.setApplicationId(applicationId);
        return this.callFido2RestApi("/registrations/challenge", request, EMPTY_MULTI_MAP, EMPTY_MULTI_MAP, RegistrationChallengeResponse.class);
    }

    public RegistrationResponse register(RegistrationRequest request) throws PowerAuthFido2Exception {
        return this.callFido2RestApi("/registrations", request, EMPTY_MULTI_MAP, EMPTY_MULTI_MAP, RegistrationResponse.class);
    }

    public RegistrationResponse register(RegistrationRequest request, MultiValueMap<String, String> queryParams, MultiValueMap<String, String> httpHeaders) throws PowerAuthFido2Exception {
        return this.callFido2RestApi("/registrations", request, queryParams, httpHeaders, RegistrationResponse.class);
    }

    public RegistrationResponse register(String applicationId, String activationName, String expectedChallenge, AuthenticatorParameters authenticatorParameters) throws PowerAuthFido2Exception {
        RegistrationRequest request = new RegistrationRequest();
        request.setApplicationId(applicationId);
        request.setActivationName(activationName);
        request.setExpectedChallenge(expectedChallenge);
        request.setAuthenticatorParameters(authenticatorParameters);
        return this.callFido2RestApi("/registrations", request, EMPTY_MULTI_MAP, EMPTY_MULTI_MAP, RegistrationResponse.class);
    }

    public AssertionChallengeResponse requestAssertionChallenge(AssertionChallengeRequest request) throws PowerAuthFido2Exception {
        return this.callFido2RestApi("/assertions/challenge", request, EMPTY_MULTI_MAP, EMPTY_MULTI_MAP, AssertionChallengeResponse.class);
    }

    public AssertionChallengeResponse requestAssertionChallenge(AssertionChallengeRequest request, MultiValueMap<String, String> queryParams, MultiValueMap<String, String> httpHeaders) throws PowerAuthFido2Exception {
        return this.callFido2RestApi("/assertions/challenge", request, queryParams, httpHeaders, AssertionChallengeResponse.class);
    }

    public AssertionChallengeResponse requestAssertionChallenge(List<String> applicationIds, String externalId, String operationType, Map<String, String> parameters) throws PowerAuthFido2Exception {
        AssertionChallengeRequest request = new AssertionChallengeRequest();
        return this.callFido2RestApi("/assertions/challenge", request, EMPTY_MULTI_MAP, EMPTY_MULTI_MAP, AssertionChallengeResponse.class);
    }

    public AssertionVerificationResponse authenticate(AssertionVerificationRequest request) throws PowerAuthFido2Exception {
        return this.callFido2RestApi("/assertions", request, EMPTY_MULTI_MAP, EMPTY_MULTI_MAP, AssertionVerificationResponse.class);
    }

    public AssertionVerificationResponse authenticate(AssertionVerificationRequest request, MultiValueMap<String, String> queryParams, MultiValueMap<String, String> httpHeaders) throws PowerAuthFido2Exception {
        return this.callFido2RestApi("/assertions", request, queryParams, httpHeaders, AssertionVerificationResponse.class);
    }

    public AssertionVerificationResponse authenticate(String id, String type, String authenticatorAttachment, AuthenticatorAssertionResponse response, String applicationId, String relyingPartyId, List<String> allowedOrigins, List<String> allowedTopOrigins, boolean requiresUserVerification, String expectedChallenge) throws PowerAuthFido2Exception {
        AssertionVerificationRequest request = new AssertionVerificationRequest();
        request.setCredentialId(id);
        request.setType(type);
        request.setAuthenticatorAttachment(authenticatorAttachment);
        request.setResponse(response);
        request.setApplicationId(applicationId);
        request.setRelyingPartyId(relyingPartyId);
        request.setAllowedOrigins(allowedOrigins);
        request.setAllowedTopOrigins(allowedTopOrigins);
        request.setRequiresUserVerification(requiresUserVerification);
        request.setExpectedChallenge(expectedChallenge);
        return this.callFido2RestApi("/assertions", request, EMPTY_MULTI_MAP, EMPTY_MULTI_MAP, AssertionVerificationResponse.class);
    }
}

