/*
 * Copyright 2018 Wultra s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.getlime.push.model.validator;

import io.getlime.push.model.request.UpdateDeviceStatusRequest;

/**
 * Validator for the device update requests.
 *
 * @author Petr Dvorak, petr@wultra.com
 */
public class UpdateDeviceStatusRequestValidator {

    /**
     * Validate {@link UpdateDeviceStatusRequest} instance.
     *
     * @param request Request to be validated.
     * @return Error message, or null in case of no error.
     */
    public static String validate(UpdateDeviceStatusRequest request) {
        if (request == null) {
            return "Request must not be null.";
        }
        if (request.getActivationId() == null) {
            return "Activation ID must not be null.";
        }
        return null;
    }

}
