/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.util.config;

import io.getlime.security.powerauth.lib.cmd.util.config.DataWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class SdkDataWriter
implements DataWriter {
    private final ByteArrayOutputStream os = new ByteArrayOutputStream();

    @Override
    public void reset() {
        this.os.reset();
    }

    @Override
    public void writeByte(byte b) {
        this.os.write(b);
    }

    @Override
    public void writeData(byte[] bytes) {
        if (!this.writeCount(bytes.length)) {
            return;
        }
        this.writeRaw(bytes);
    }

    @Override
    public void writeString(String str) {
        this.writeData(str.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void writeRaw(byte[] bytes) {
        try {
            this.os.write(bytes);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean writeCount(int count) {
        if (count < 0) {
            return false;
        }
        long n = Integer.toUnsignedLong(count);
        if (n <= 127L) {
            this.writeByte((byte)n);
        } else if (n <= 16383L) {
            this.writeByte((byte)(n >> 8 & 0x3FL | 0x80L));
            this.writeByte((byte)(n & 0xFFL));
        } else if (n <= 0x3FFFFFFFL) {
            this.writeByte((byte)(n >> 24 & 0x3FL | 0xC0L));
            this.writeByte((byte)(n >> 16 & 0xFFL));
            this.writeByte((byte)(n >> 8 & 0xFFL));
            this.writeByte((byte)(n & 0xFFL));
        } else {
            return false;
        }
        return true;
    }

    @Override
    public byte[] getSerializedData() {
        return this.os.toByteArray();
    }

    @Override
    public int getMaxCount() {
        return 0x3FFFFFFF;
    }
}

