/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.util.config;

import io.getlime.security.powerauth.lib.cmd.util.config.DataReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkDataReader
implements DataReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SdkDataReader.class);
    private final byte[] data;
    private int offset = 0;

    public SdkDataReader(byte[] data) {
        this.data = data;
    }

    @Override
    public void reset() {
        this.offset = 0;
    }

    @Override
    public int remainingSize() {
        return this.data.length - this.offset;
    }

    @Override
    public int currentOffset() {
        return this.offset;
    }

    @Override
    public boolean canReadSize(int size) {
        return this.remainingSize() >= size;
    }

    @Override
    public boolean skipBytes(int size) {
        if (!this.canReadSize(size)) {
            return false;
        }
        this.offset += size;
        return true;
    }

    @Override
    public byte[] readData(int expectedSize) {
        Integer size = this.readCount();
        if (size == null) {
            return null;
        }
        if (!this.canReadSize(size)) {
            return null;
        }
        if (expectedSize > 0 && expectedSize != size) {
            return null;
        }
        byte[] result = Arrays.copyOfRange(this.data, this.offset, this.offset + size);
        this.offset += size.intValue();
        return result;
    }

    @Override
    public String readString() {
        Integer size = this.readCount();
        if (size == null) {
            return null;
        }
        if (!this.canReadSize(size)) {
            return null;
        }
        byte[] strData = Arrays.copyOfRange(this.data, this.offset, this.offset + size);
        this.offset += size.intValue();
        return new String(strData, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] readRaw(int size) {
        if (!this.canReadSize(size)) {
            return null;
        }
        byte[] result = Arrays.copyOfRange(this.data, this.offset, this.offset + size);
        this.offset += size;
        return result;
    }

    @Override
    public Byte readByte() {
        if (!this.canReadSize(1)) {
            return null;
        }
        byte result = this.data[this.offset];
        ++this.offset;
        return result;
    }

    @Override
    public Integer readCount() {
        Byte firstByte = this.readByte();
        if (firstByte == null) {
            return null;
        }
        int byte1u = Byte.toUnsignedInt(firstByte);
        int marker = byte1u & 0xC0;
        if (marker == 0 || marker == 64) {
            return byte1u;
        }
        int additionalByteCount = marker == 192 ? 3 : 1;
        byte[] remainingBytes = this.readRaw(additionalByteCount);
        if (remainingBytes == null) {
            return null;
        }
        int byte2u = Byte.toUnsignedInt(remainingBytes[0]);
        if (marker == 192) {
            int byte3u = Byte.toUnsignedInt(remainingBytes[1]);
            int byte4u = Byte.toUnsignedInt(remainingBytes[2]);
            return (byte1u & 0x3F) << 24 | byte2u << 16 | byte3u << 8 | byte4u;
        }
        return (byte1u & 0x3F) << 8 | byte2u;
    }
}

