/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.util;

import io.getlime.security.powerauth.crypto.lib.encryptor.ClientEncryptor;
import io.getlime.security.powerauth.crypto.lib.encryptor.exception.EncryptorException;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptedRequest;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptedResponse;
import io.getlime.security.powerauth.lib.cmd.steps.context.ResponseContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.StepContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.security.SimpleSecurityContext;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.rest.api.model.request.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.EciesEncryptedResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class SecurityUtil {
    public static EncryptedRequest encryptObject(ClientEncryptor encryptor, Object value) throws EncryptorException, IOException {
        ByteArrayOutputStream baosL = new ByteArrayOutputStream();
        RestClientConfiguration.defaultMapper().writeValue((OutputStream)baosL, value);
        return encryptor.encryptRequest(baosL.toByteArray());
    }

    public static EciesEncryptedRequest createEncryptedRequest(EncryptedRequest encryptedRequest) {
        EciesEncryptedRequest request = new EciesEncryptedRequest();
        request.setEncryptedData(encryptedRequest.getEncryptedData());
        request.setEphemeralPublicKey(encryptedRequest.getEphemeralPublicKey());
        request.setMac(encryptedRequest.getMac());
        request.setNonce(encryptedRequest.getNonce());
        request.setTimestamp(encryptedRequest.getTimestamp());
        request.setTemporaryKeyId(encryptedRequest.getTemporaryKeyId());
        return request;
    }

    public static void processEncryptedResponse(StepContext<?, EciesEncryptedResponse> stepContext, String stepId) throws Exception {
        ResponseContext<EciesEncryptedResponse> responseContext = stepContext.getResponseContext();
        SimpleSecurityContext securityContext = (SimpleSecurityContext)stepContext.getSecurityContext();
        EciesEncryptedResponse responseObject = responseContext.getResponseBodyObject();
        byte[] decryptedBytes = securityContext.getEncryptor().decryptResponse(new EncryptedResponse(responseObject.getEncryptedData(), responseObject.getMac(), responseObject.getNonce(), responseObject.getTimestamp()));
        String decryptedMessage = new String(decryptedBytes, StandardCharsets.UTF_8);
        stepContext.getModel().getResultStatus().setResponseData(decryptedMessage);
        stepContext.getStepLogger().writeItem(stepId + "-response-decrypt", "Decrypted Response", "Following data were decrypted", "OK", decryptedMessage);
    }
}

