/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.util;

import com.wultra.core.rest.client.base.DefaultRestClient;
import com.wultra.core.rest.client.base.RestClient;
import com.wultra.core.rest.client.base.RestClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(RestClientFactory.class);
    private static RestClient restClient;
    private static boolean acceptInvalidSslCertificate;

    public static RestClient getRestClient() {
        if (restClient != null) {
            return restClient;
        }
        try {
            restClient = DefaultRestClient.builder().acceptInvalidCertificate(acceptInvalidSslCertificate).build();
            return restClient;
        }
        catch (RestClientException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static boolean isAcceptInvalidSslCertificate() {
        return acceptInvalidSslCertificate;
    }

    public static void setAcceptInvalidSslCertificate(boolean acceptInvalidSslCertificate) {
        RestClientFactory.acceptInvalidSslCertificate = acceptInvalidSslCertificate;
    }
}

