/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v3;

import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptorId;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptorScope;
import io.getlime.security.powerauth.lib.cmd.consts.BackwardCompatibilityConst;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthConst;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthStep;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthVersion;
import io.getlime.security.powerauth.lib.cmd.header.PowerAuthHeaderFactory;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.StepLoggerFactory;
import io.getlime.security.powerauth.lib.cmd.status.ResultStatusService;
import io.getlime.security.powerauth.lib.cmd.steps.AbstractBaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.context.RequestContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.StepContext;
import io.getlime.security.powerauth.lib.cmd.steps.model.TokenAndEncryptStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.model.data.TokenAndEncryptionHeaderData;
import io.getlime.security.powerauth.lib.cmd.util.SecurityUtil;
import io.getlime.security.powerauth.rest.api.model.response.EciesEncryptedResponse;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Component
public class TokenAndEncryptStep
extends AbstractBaseStep<TokenAndEncryptStepModel, EciesEncryptedResponse> {
    private final PowerAuthHeaderFactory powerAuthHeaderFactory;

    @Autowired
    public TokenAndEncryptStep(PowerAuthHeaderFactory powerAuthHeaderFactory, ResultStatusService resultStatusService, StepLoggerFactory stepLoggerFactory) {
        super(PowerAuthStep.TOKEN_ENCRYPT, PowerAuthVersion.VERSION_3, resultStatusService, stepLoggerFactory);
        this.powerAuthHeaderFactory = powerAuthHeaderFactory;
    }

    public TokenAndEncryptStep() {
        this(BackwardCompatibilityConst.POWER_AUTH_HEADER_FACTORY, BackwardCompatibilityConst.RESULT_STATUS_SERVICE, BackwardCompatibilityConst.STEP_LOGGER_FACTORY);
    }

    @Override
    protected ParameterizedTypeReference<EciesEncryptedResponse> getResponseTypeReference() {
        return PowerAuthConst.RESPONSE_TYPE_REFERENCE_V3;
    }

    @Override
    public StepContext<TokenAndEncryptStepModel, EciesEncryptedResponse> prepareStepContext(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        TokenAndEncryptStepModel model = new TokenAndEncryptStepModel();
        model.fromMap(context);
        RequestContext requestContext = RequestContext.builder().signatureHttpMethod(model.getHttpMethod()).uri(model.getUriString()).build();
        StepContext<TokenAndEncryptStepModel, EciesEncryptedResponse> stepContext = this.buildStepContext(stepLogger, model, requestContext);
        if (model.getHttpMethod() == null) {
            stepLogger.writeError(this.getStep().id() + "-error-http-method", "HTTP method not specified", "Specify HTTP method to use for sending request");
            stepLogger.writeDoneFailed("token-encrypt-failed");
            return null;
        }
        if (HttpMethod.GET.name().equals(model.getHttpMethod().toUpperCase())) {
            stepLogger.writeError(this.getStep().id() + "-error-http-method-invalid", "Token and Encrypt Request Failed", "Unsupported HTTP method: " + model.getHttpMethod().toUpperCase());
            stepLogger.writeDoneFailed("token-encrypt-failed");
            return null;
        }
        byte[] requestDataBytes = model.getData();
        if (requestDataBytes == null || requestDataBytes.length == 0) {
            requestDataBytes = new byte[]{};
            stepLogger.writeItem(this.getStep().id() + "-warning-empty-data", "Empty data", "Data file was not found, signature will contain no data", "WARNING", null);
        }
        stepLogger.writeItem(this.getStep().id() + "-request-prepare", "Preparing Request Data", "Following data will be encrypted", "OK", requestDataBytes);
        requestContext.setRequestObject(requestDataBytes);
        this.addEncryptedRequest(stepContext, model.getApplicationKey(), model.getApplicationSecret(), EncryptorId.ACTIVATION_SCOPE_GENERIC, requestDataBytes, EncryptorScope.ACTIVATION_SCOPE);
        this.powerAuthHeaderFactory.getHeaderProvider(model).addHeader((StepContext<? extends TokenAndEncryptionHeaderData, ?>)stepContext);
        return stepContext;
    }

    @Override
    public void processResponse(StepContext<TokenAndEncryptStepModel, EciesEncryptedResponse> stepContext) throws Exception {
        SecurityUtil.processEncryptedResponse(stepContext, this.getStep().id());
    }
}

