/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v3;

import io.getlime.security.powerauth.lib.cmd.consts.BackwardCompatibilityConst;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthStep;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthVersion;
import io.getlime.security.powerauth.lib.cmd.header.PowerAuthHeaderFactory;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.StepLoggerFactory;
import io.getlime.security.powerauth.lib.cmd.status.ResultStatusService;
import io.getlime.security.powerauth.lib.cmd.steps.AbstractActivationStep;
import io.getlime.security.powerauth.lib.cmd.steps.context.RequestContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.StepContext;
import io.getlime.security.powerauth.lib.cmd.steps.model.PrepareActivationStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.model.data.EncryptionHeaderData;
import io.getlime.security.powerauth.rest.api.model.entity.ActivationType;
import io.getlime.security.powerauth.rest.api.model.request.ActivationLayer1Request;
import io.getlime.security.powerauth.rest.api.model.request.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.EciesEncryptedResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="prepareActivationStepV3")
public class PrepareActivationStep
extends AbstractActivationStep<PrepareActivationStepModel> {
    private final PowerAuthHeaderFactory powerAuthHeaderFactory;

    @Autowired
    public PrepareActivationStep(PowerAuthHeaderFactory powerAuthHeaderFactory, ResultStatusService resultStatusService, StepLoggerFactory stepLoggerFactory) {
        super(PowerAuthStep.ACTIVATION_CREATE, PowerAuthVersion.VERSION_3, resultStatusService, stepLoggerFactory);
        this.powerAuthHeaderFactory = powerAuthHeaderFactory;
    }

    public PrepareActivationStep() {
        this(BackwardCompatibilityConst.POWER_AUTH_HEADER_FACTORY, BackwardCompatibilityConst.RESULT_STATUS_SERVICE, BackwardCompatibilityConst.STEP_LOGGER_FACTORY);
    }

    @Override
    public StepContext<PrepareActivationStepModel, EciesEncryptedResponse> prepareStepContext(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        PrepareActivationStepModel model = new PrepareActivationStepModel();
        model.fromMap(context);
        Pattern p = Pattern.compile("^[A-Z2-7]{5}-[A-Z2-7]{5}-[A-Z2-7]{5}-[A-Z2-7]{5}$");
        Matcher m = p.matcher(model.getActivationCode());
        if (!m.find()) {
            stepLogger.writeError("activation-create-activation-code", "Prepare activation step failed", "Activation code has invalid format");
            stepLogger.writeDoneFailed("activation-create-error-activation-code");
            return null;
        }
        String activationCode = model.getActivationCode();
        HashMap<String, String> objectMap = new HashMap<String, String>();
        objectMap.put("activationCode", activationCode);
        stepLogger.writeItem(this.getStep().id() + "-activation-code", "Activation code", "Storing activation code", "OK", objectMap);
        RequestContext requestContext = RequestContext.builder().uri(model.getUriString() + "/pa/v3/activation/create").build();
        StepContext<PrepareActivationStepModel, EciesEncryptedResponse> stepContext = this.buildStepContext(stepLogger, model, requestContext);
        this.addEncryptedRequest(stepContext);
        this.powerAuthHeaderFactory.getHeaderProvider(model).addHeader((StepContext<? extends EncryptionHeaderData, ?>)stepContext);
        return stepContext;
    }

    @Override
    protected ActivationLayer1Request prepareLayer1Request(StepContext<PrepareActivationStepModel, EciesEncryptedResponse> stepContext, EciesEncryptedRequest encryptedRequestL2) {
        ActivationLayer1Request requestL1 = new ActivationLayer1Request();
        requestL1.setType(ActivationType.CODE);
        requestL1.setActivationData(encryptedRequestL2);
        HashMap<String, String> identityAttributes = new HashMap<String, String>();
        identityAttributes.put("code", stepContext.getModel().getActivationCode());
        requestL1.setIdentityAttributes(identityAttributes);
        requestL1.setCustomAttributes(stepContext.getModel().getCustomAttributes());
        return requestL1;
    }
}

