/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v3;

import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptorId;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptorScope;
import io.getlime.security.powerauth.lib.cmd.consts.BackwardCompatibilityConst;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthConst;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthStep;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthVersion;
import io.getlime.security.powerauth.lib.cmd.header.PowerAuthHeaderFactory;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.StepLoggerFactory;
import io.getlime.security.powerauth.lib.cmd.status.ResultStatusService;
import io.getlime.security.powerauth.lib.cmd.steps.AbstractBaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.context.RequestContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.StepContext;
import io.getlime.security.powerauth.lib.cmd.steps.model.CreateTokenStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.model.data.SignatureHeaderData;
import io.getlime.security.powerauth.rest.api.model.entity.TokenResponsePayload;
import io.getlime.security.powerauth.rest.api.model.response.EciesEncryptedResponse;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Component;

@Component(value="createTokenStepV3")
public class CreateTokenStep
extends AbstractBaseStep<CreateTokenStepModel, EciesEncryptedResponse> {
    private final PowerAuthHeaderFactory powerAuthHeaderFactory;

    @Autowired
    public CreateTokenStep(PowerAuthHeaderFactory powerAuthHeaderFactory, ResultStatusService resultStatusService, StepLoggerFactory stepLoggerFactory) {
        super(PowerAuthStep.TOKEN_CREATE, PowerAuthVersion.VERSION_3, resultStatusService, stepLoggerFactory);
        this.powerAuthHeaderFactory = powerAuthHeaderFactory;
    }

    public CreateTokenStep() {
        this(BackwardCompatibilityConst.POWER_AUTH_HEADER_FACTORY, BackwardCompatibilityConst.RESULT_STATUS_SERVICE, BackwardCompatibilityConst.STEP_LOGGER_FACTORY);
    }

    @Override
    protected ParameterizedTypeReference<EciesEncryptedResponse> getResponseTypeReference() {
        return PowerAuthConst.RESPONSE_TYPE_REFERENCE_V3;
    }

    @Override
    public StepContext<CreateTokenStepModel, EciesEncryptedResponse> prepareStepContext(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        CreateTokenStepModel model = new CreateTokenStepModel();
        model.fromMap(context);
        RequestContext requestContext = RequestContext.builder().signatureHttpMethod("POST").signatureRequestUri("/pa/token/create").uri(model.getUriString() + "/pa/v3/token/create").build();
        StepContext<CreateTokenStepModel, EciesEncryptedResponse> stepContext = this.buildStepContext(stepLogger, model, requestContext);
        this.addEncryptedRequest(stepContext, model.getApplicationKey(), model.getApplicationSecret(), EncryptorId.CREATE_TOKEN, PowerAuthConst.EMPTY_JSON_BYTES, EncryptorScope.ACTIVATION_SCOPE);
        this.powerAuthHeaderFactory.getHeaderProvider(model).addHeader((StepContext<? extends SignatureHeaderData, ?>)stepContext);
        this.incrementCounter(model);
        return stepContext;
    }

    @Override
    public void processResponse(StepContext<CreateTokenStepModel, EciesEncryptedResponse> stepContext) throws Exception {
        TokenResponsePayload tokenResponsePayload = this.decryptResponse(stepContext, TokenResponsePayload.class);
        stepContext.getStepLogger().writeItem(this.getStep().id() + "-token-obtained", "Token successfully obtained", "Token was successfully generated and decrypted", "OK", Map.of("tokenId", tokenResponsePayload.getTokenId(), "tokenSecret", tokenResponsePayload.getTokenSecret()));
    }
}

