/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v3;

import io.getlime.core.rest.model.base.response.Response;
import io.getlime.security.powerauth.lib.cmd.consts.BackwardCompatibilityConst;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthConst;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthStep;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthVersion;
import io.getlime.security.powerauth.lib.cmd.header.PowerAuthHeaderFactory;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.StepLoggerFactory;
import io.getlime.security.powerauth.lib.cmd.status.ResultStatusService;
import io.getlime.security.powerauth.lib.cmd.steps.AbstractBaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.context.RequestContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.StepContext;
import io.getlime.security.powerauth.lib.cmd.steps.model.CommitUpgradeStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.model.data.SignatureHeaderData;
import io.getlime.security.powerauth.lib.cmd.steps.pojo.ResultStatusObject;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Component;

@Component
public class CommitUpgradeStep
extends AbstractBaseStep<CommitUpgradeStepModel, Response> {
    private static final ParameterizedTypeReference<Response> RESPONSE_TYPE_REFERENCE = new ParameterizedTypeReference<Response>(){};
    private final PowerAuthHeaderFactory powerAuthHeaderFactory;

    @Autowired
    public CommitUpgradeStep(PowerAuthHeaderFactory powerAuthHeaderFactory, ResultStatusService resultStatusService, StepLoggerFactory stepLoggerFactory) {
        super(PowerAuthStep.UPGRADE_COMMIT, PowerAuthVersion.VERSION_3, resultStatusService, stepLoggerFactory);
        this.powerAuthHeaderFactory = powerAuthHeaderFactory;
    }

    public CommitUpgradeStep() {
        this(BackwardCompatibilityConst.POWER_AUTH_HEADER_FACTORY, BackwardCompatibilityConst.RESULT_STATUS_SERVICE, BackwardCompatibilityConst.STEP_LOGGER_FACTORY);
    }

    @Override
    protected ParameterizedTypeReference<Response> getResponseTypeReference() {
        return RESPONSE_TYPE_REFERENCE;
    }

    @Override
    public StepContext<CommitUpgradeStepModel, Response> prepareStepContext(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        CommitUpgradeStepModel model = new CommitUpgradeStepModel();
        model.fromMap(context);
        ResultStatusObject resultStatusObject = model.getResultStatus();
        RequestContext requestContext = RequestContext.builder().signatureHttpMethod("POST").signatureRequestUri("/pa/upgrade/commit").uri(model.getUriString() + "/pa/v3/upgrade/commit").build();
        StepContext<CommitUpgradeStepModel, Response> stepContext = this.buildStepContext(stepLogger, model, requestContext);
        resultStatusObject.setVersion(3L);
        requestContext.setRequestObject(PowerAuthConst.EMPTY_JSON_BYTES);
        this.powerAuthHeaderFactory.getHeaderProvider(model).addHeader((StepContext<? extends SignatureHeaderData, ?>)stepContext);
        return stepContext;
    }

    @Override
    public void processResponse(StepContext<CommitUpgradeStepModel, Response> stepContext) throws Exception {
        CommitUpgradeStepModel model = stepContext.getModel();
        this.incrementCounter(model);
        stepContext.getStepLogger().writeItem(this.getStep().id() + "-upgrade-done", "Upgrade commit successfully completed", "Upgrade commit was successfully completed", "OK", null);
    }
}

