/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.pojo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import java.security.PublicKey;
import java.util.Base64;
import javax.crypto.SecretKey;
import lombok.Generated;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultStatusObject {
    private static final Logger logger = LoggerFactory.getLogger(ResultStatusObject.class);
    private static final KeyConvertor KEY_CONVERTOR = new KeyConvertor();
    @JsonIgnore
    private JSONObject jsonObject = new JSONObject();

    public String getActivationId() {
        return (String)this.jsonObject.get((Object)"activationId");
    }

    public void setActivationId(String activationId) {
        this.jsonObject.put((Object)"activationId", (Object)activationId);
    }

    public Long getCounter() {
        return (Long)this.jsonObject.get((Object)"counter");
    }

    public void setCounter(Long counter) {
        this.jsonObject.put((Object)"counter", (Object)counter);
    }

    public String getCtrData() {
        return (String)this.jsonObject.get((Object)"ctrData");
    }

    public void setCtrData(String ctrData) {
        this.jsonObject.put((Object)"ctrData", (Object)ctrData);
    }

    @JsonIgnore
    public byte[] getEncryptedDevicePrivateKeyBytes() {
        String encryptedDevicePrivateKey = (String)this.jsonObject.get((Object)"encryptedDevicePrivateKey");
        return Base64.getDecoder().decode(encryptedDevicePrivateKey);
    }

    @JsonIgnore
    public void setEncryptedDevicePrivateKeyBytes(byte[] encryptedDevicePrivateKeyBytes) {
        String encryptedDevicePrivateKey = Base64.getEncoder().encodeToString(encryptedDevicePrivateKeyBytes);
        this.jsonObject.put((Object)"encryptedDevicePrivateKey", (Object)encryptedDevicePrivateKey);
    }

    public String getEncryptedDevicePrivateKey() {
        return (String)this.jsonObject.get((Object)"encryptedDevicePrivateKey");
    }

    public void setEncryptedDevicePrivateKey(String encryptedDevicePrivateKey) {
        this.jsonObject.put((Object)"encryptedDevicePrivateKey", (Object)encryptedDevicePrivateKey);
    }

    public String getResponseData() {
        return (String)this.jsonObject.get((Object)"responseData");
    }

    public void setResponseData(String responseData) {
        this.jsonObject.put((Object)"responseData", (Object)responseData);
    }

    @JsonIgnore
    public PublicKey getServerPublicKeyObject() throws Exception {
        String serverPublicKey = (String)this.jsonObject.get((Object)"serverPublicKey");
        return KEY_CONVERTOR.convertBytesToPublicKey(Base64.getDecoder().decode(serverPublicKey));
    }

    @JsonIgnore
    public void setServerPublicKeyObject(PublicKey serverPublicKeyObject) throws Exception {
        String serverPublicKey = Base64.getEncoder().encodeToString(KEY_CONVERTOR.convertPublicKeyToBytes(serverPublicKeyObject));
        this.jsonObject.put((Object)"serverPublicKey", (Object)serverPublicKey);
    }

    public String getServerPublicKey() {
        return (String)this.jsonObject.get((Object)"serverPublicKey");
    }

    public void setServerPublicKey(String serverPublicKey) {
        this.jsonObject.put((Object)"serverPublicKey", (Object)serverPublicKey);
    }

    @JsonIgnore
    public SecretKey getSignatureBiometryKeyObject() {
        String signatureBiometryKey = (String)this.jsonObject.get((Object)"signatureBiometryKey");
        if (signatureBiometryKey == null) {
            return null;
        }
        return KEY_CONVERTOR.convertBytesToSharedSecretKey(Base64.getDecoder().decode(signatureBiometryKey));
    }

    @JsonIgnore
    public void setSignatureBiometryKeyObject(SecretKey signatureBiometryKeyObject) {
        String signatureBiometryKey = Base64.getEncoder().encodeToString(KEY_CONVERTOR.convertSharedSecretKeyToBytes(signatureBiometryKeyObject));
        this.jsonObject.put((Object)"signatureBiometryKey", (Object)signatureBiometryKey);
    }

    public String getSignatureBiometryKey() {
        return (String)this.jsonObject.get((Object)"signatureBiometryKey");
    }

    public void setSignatureBiometryKey(String signatureBiometryKey) {
        this.jsonObject.put((Object)"signatureBiometryKey", (Object)signatureBiometryKey);
    }

    @JsonIgnore
    public byte[] getSignatureKnowledgeKeyEncryptedBytes() {
        String signatureKnowledgeKeyEncrypted = (String)this.jsonObject.get((Object)"signatureKnowledgeKeyEncrypted");
        return Base64.getDecoder().decode(signatureKnowledgeKeyEncrypted);
    }

    @JsonIgnore
    public void setSignatureKnowledgeKeyEncryptedBytes(byte[] signatureKnowledgeKeyEncryptedBytes) {
        String signatureKnowledgeKeyEncrypted = Base64.getEncoder().encodeToString(signatureKnowledgeKeyEncryptedBytes);
        this.jsonObject.put((Object)"signatureKnowledgeKeyEncrypted", (Object)signatureKnowledgeKeyEncrypted);
    }

    public String getSignatureKnowledgeKeyEncrypted() {
        return (String)this.jsonObject.get((Object)"signatureKnowledgeKeyEncrypted");
    }

    public void setSignatureKnowledgeKeyEncrypted(String signatureKnowledgeKeyEncrypted) {
        this.jsonObject.put((Object)"signatureKnowledgeKeyEncrypted", (Object)signatureKnowledgeKeyEncrypted);
    }

    @JsonIgnore
    public byte[] getSignatureKnowledgeKeySaltBytes() {
        String signatureKnowledgeKeySalt = (String)this.jsonObject.get((Object)"signatureKnowledgeKeySalt");
        return Base64.getDecoder().decode(signatureKnowledgeKeySalt);
    }

    @JsonIgnore
    public void setSignatureKnowledgeKeySaltBytes(byte[] signatureKnowledgeKeySaltBytes) {
        String signatureKnowledgeKeySalt = Base64.getEncoder().encodeToString(signatureKnowledgeKeySaltBytes);
        this.jsonObject.put((Object)"signatureKnowledgeKeySalt", (Object)signatureKnowledgeKeySalt);
    }

    public String getSignatureKnowledgeKeySalt() {
        return (String)this.jsonObject.get((Object)"signatureKnowledgeKeySalt");
    }

    public void setSignatureKnowledgeKeySalt(String signatureKnowledgeKeySalt) {
        this.jsonObject.put((Object)"signatureKnowledgeKeySalt", (Object)signatureKnowledgeKeySalt);
    }

    @JsonIgnore
    public SecretKey getSignaturePossessionKeyObject() {
        String signaturePossessionKey = (String)this.jsonObject.get((Object)"signaturePossessionKey");
        if (signaturePossessionKey == null) {
            return null;
        }
        return KEY_CONVERTOR.convertBytesToSharedSecretKey(Base64.getDecoder().decode(signaturePossessionKey));
    }

    @JsonIgnore
    public void setSignaturePossessionKeyObject(SecretKey signaturePossessionKeyObject) {
        String signaturePossessionKey = Base64.getEncoder().encodeToString(KEY_CONVERTOR.convertSharedSecretKeyToBytes(signaturePossessionKeyObject));
        this.jsonObject.put((Object)"signaturePossessionKey", (Object)signaturePossessionKey);
    }

    public String getSignaturePossessionKey() {
        return (String)this.jsonObject.get((Object)"signaturePossessionKey");
    }

    public void setSignaturePossessionKey(String signaturePossessionKey) {
        this.jsonObject.put((Object)"signaturePossessionKey", (Object)signaturePossessionKey);
    }

    @JsonIgnore
    public SecretKey getTransportMasterKeyObject() {
        String transportMasterKey = (String)this.jsonObject.get((Object)"transportMasterKey");
        if (transportMasterKey == null) {
            return null;
        }
        return KEY_CONVERTOR.convertBytesToSharedSecretKey(Base64.getDecoder().decode(transportMasterKey));
    }

    @JsonIgnore
    public void setTransportMasterKeyObject(SecretKey transportMasterKeyObject) {
        String transportMasterKey = Base64.getEncoder().encodeToString(KEY_CONVERTOR.convertSharedSecretKeyToBytes(transportMasterKeyObject));
        this.jsonObject.put((Object)"transportMasterKey", (Object)transportMasterKey);
    }

    public String getTransportMasterKey() {
        return (String)this.jsonObject.get((Object)"transportMasterKey");
    }

    public void setTransportMasterKey(String transportMasterKey) {
        this.jsonObject.put((Object)"transportMasterKey", (Object)transportMasterKey);
    }

    public Long getVersion() {
        return (Long)this.jsonObject.get((Object)"version");
    }

    public void setVersion(Long version) {
        this.jsonObject.put((Object)"version", (Object)version);
    }

    public static ResultStatusObject fromJsonObject(JSONObject jsonObject) {
        ResultStatusObject resultStatusObject;
        try {
            resultStatusObject = new ResultStatusObject();
            resultStatusObject.setJsonObject(jsonObject);
        }
        catch (Exception e) {
            logger.error("Invalid json data specified for result status object", (Throwable)e);
            resultStatusObject = new ResultStatusObject();
        }
        return resultStatusObject;
    }

    @Generated
    public JSONObject getJsonObject() {
        return this.jsonObject;
    }

    @JsonIgnore
    @Generated
    public void setJsonObject(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultStatusObject)) {
            return false;
        }
        ResultStatusObject other = (ResultStatusObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JSONObject this$jsonObject = this.getJsonObject();
        JSONObject other$jsonObject = other.getJsonObject();
        return !(this$jsonObject == null ? other$jsonObject != null : !this$jsonObject.equals(other$jsonObject));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResultStatusObject;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JSONObject $jsonObject = this.getJsonObject();
        result = result * 59 + ($jsonObject == null ? 43 : $jsonObject.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ResultStatusObject(jsonObject=" + String.valueOf(this.getJsonObject()) + ")";
    }

    @Generated
    public ResultStatusObject() {
    }

    @Generated
    public ResultStatusObject(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
    }
}

