/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps;

import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthStep;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthVersion;
import io.getlime.security.powerauth.lib.cmd.exception.PowerAuthCmdException;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.BaseStep;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StepProvider {
    private final StepLogger stepLogger;
    private Map<PowerAuthStep, Map<PowerAuthVersion, BaseStep>> mappingStepVersion = Collections.emptyMap();

    @Autowired
    public StepProvider(List<BaseStep> stepList, StepLogger stepLogger) {
        this.stepLogger = stepLogger;
        this.registerPowerAuthSteps(stepList);
    }

    private void registerPowerAuthSteps(List<BaseStep> steps) {
        HashMap<PowerAuthStep, Map<PowerAuthVersion, BaseStep>> mappingStepVersion = new HashMap<PowerAuthStep, Map<PowerAuthVersion, BaseStep>>();
        steps.forEach(step -> {
            Map mappingVersion = mappingStepVersion.computeIfAbsent(step.getStep(), value -> new HashMap());
            step.getSupportedVersions().forEach(supportedVersion -> mappingVersion.put(supportedVersion, step));
        });
        this.mappingStepVersion = mappingStepVersion;
    }

    public boolean exists(PowerAuthStep step) {
        return this.mappingStepVersion.containsKey((Object)step);
    }

    public BaseStep getStep(PowerAuthStep step, PowerAuthVersion version) throws PowerAuthCmdException {
        return Optional.ofNullable(this.mappingStepVersion.get((Object)step).get((Object)version)).orElseThrow(() -> {
            this.stepLogger.writeItem("generic-error-version", "Unsupported version", "The version you specified is not supported: " + String.valueOf((Object)version), "ERROR", null);
            return new PowerAuthCmdException();
        });
    }

    public Set<PowerAuthStep> getAvailableSteps(PowerAuthVersion version) {
        HashSet<PowerAuthStep> steps = new HashSet<PowerAuthStep>();
        for (PowerAuthStep step : this.mappingStepVersion.keySet()) {
            if (!this.mappingStepVersion.get((Object)step).containsKey((Object)version)) continue;
            steps.add(step);
        }
        return steps;
    }

    public Set<PowerAuthVersion> getSupportedVersions(PowerAuthStep step) {
        return Optional.ofNullable(this.mappingStepVersion.get((Object)step)).orElse(Collections.emptyMap()).keySet().stream().sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

