/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps;

import io.getlime.security.powerauth.crypto.lib.config.SignatureConfiguration;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import io.getlime.security.powerauth.crypto.lib.util.SignatureUtils;
import io.getlime.security.powerauth.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.lib.cmd.consts.BackwardCompatibilityConst;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthStep;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthVersion;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.StepLoggerFactory;
import io.getlime.security.powerauth.lib.cmd.status.ResultStatusService;
import io.getlime.security.powerauth.lib.cmd.steps.AbstractBaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.context.RequestContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.StepContext;
import io.getlime.security.powerauth.lib.cmd.steps.model.ComputeOfflineSignatureStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.pojo.ResultStatusObject;
import io.getlime.security.powerauth.lib.cmd.util.CounterUtil;
import io.getlime.security.powerauth.lib.cmd.util.EncryptedStorageUtil;
import java.io.Console;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Component
public class ComputeOfflineSignatureStep
extends AbstractBaseStep<ComputeOfflineSignatureStepModel, Void> {
    private static final KeyGenerator KEY_GENERATOR = new KeyGenerator();
    private static final KeyConvertor KEY_CONVERTOR = new KeyConvertor();
    private static final SignatureUtils SIGNATURE_UTILS = new SignatureUtils();

    @Autowired
    public ComputeOfflineSignatureStep(ResultStatusService resultStatusService, StepLoggerFactory stepLoggerFactory) {
        super(PowerAuthStep.SIGNATURE_OFFLINE_COMPUTE, PowerAuthVersion.ALL_VERSIONS, resultStatusService, stepLoggerFactory);
    }

    public ComputeOfflineSignatureStep() {
        this(BackwardCompatibilityConst.RESULT_STATUS_SERVICE, BackwardCompatibilityConst.STEP_LOGGER_FACTORY);
    }

    @Override
    public ParameterizedTypeReference<Void> getResponseTypeReference() {
        return null;
    }

    @Override
    public StepContext<ComputeOfflineSignatureStepModel, Void> prepareStepContext(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        char[] password;
        ComputeOfflineSignatureStepModel model = new ComputeOfflineSignatureStepModel();
        model.fromMap(context);
        RequestContext requestContext = RequestContext.builder().uri(model.getUriString()).build();
        StepContext<ComputeOfflineSignatureStepModel, Void> stepContext = this.buildStepContext(stepLogger, model, requestContext);
        if (model.getQrCodeData() == null) {
            stepLogger.writeError(this.getStep().id() + "-error-missing-qr-code-data", "Missing offline signature data", "Specify offline signature data which is encoded in QR code");
            stepLogger.writeDoneFailed(this.getStep().id() + "-failed");
            return null;
        }
        String offlineData = this.unescape(model.getQrCodeData());
        HashMap<String, String> inputMap = new HashMap<String, String>();
        inputMap.put("qrCodeData", offlineData);
        stepLogger.writeItem(this.getStep().id() + "-start", "Offline Signature Computation Started", null, "OK", inputMap);
        if (model.getPassword() == null) {
            Console console = System.console();
            password = console.readPassword("Enter your password to unlock the knowledge related key: ", new Object[0]);
            Assert.state((password != null ? 1 : 0) != 0, (String)"Not able to read a password from the console");
        } else {
            password = model.getPassword().toCharArray();
        }
        String offlineSignature = this.calculateOfflineSignature(offlineData, stepLogger, model.getResultStatus(), password);
        if (offlineSignature == null) {
            return null;
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("offlineSignature", offlineSignature);
        stepLogger.writeItem(this.getStep().id() + "-finished", "Offline Signature Computation Finished", null, "OK", resultMap);
        this.incrementCounter(stepContext.getModel());
        return stepContext;
    }

    private String unescape(String text) {
        return text.replace("\\n", "\n");
    }

    private String calculateOfflineSignature(String offlineData, StepLogger stepLogger, ResultStatusObject resultStatusObject, char[] password) {
        String[] parts = offlineData.split("\n");
        if (parts.length < 7) {
            stepLogger.writeError(this.getStep().id() + "-error-invalid-qr-code-data", "Invalid QR code data", "Invalid QR code, expected 7 lines of data or more");
            stepLogger.writeDoneFailed(this.getStep().id() + "-failed");
            return null;
        }
        String operationId = parts[0];
        String operationData = parts[3];
        String nonce = parts[parts.length - 2];
        String signatureLine = parts[parts.length - 1];
        String totp = parts.length > 7 && parts[parts.length - 3].matches("^[0-9]+$") ? parts[parts.length - 3] : null;
        String signatureType = signatureLine.substring(0, 1);
        if (!"1".equals(signatureType)) {
            stepLogger.writeError(this.getStep().id() + "-error-invalid-signature-type", "Invalid signature type", "Personalized offline signature expected, however other signature type is used");
            stepLogger.writeDoneFailed(this.getStep().id() + "-failed");
            return null;
        }
        try {
            String ecdsaSignature = signatureLine.substring(1);
            byte[] serverPublicKeyBytes = Base64.getDecoder().decode(resultStatusObject.getServerPublicKey());
            ECPublicKey serverPublicKey = (ECPublicKey)KEY_CONVERTOR.convertBytesToPublicKey(serverPublicKeyBytes);
            String offlineDataWithoutSignature = offlineData.substring(0, offlineData.length() - ecdsaSignature.length());
            boolean dataSignatureValid = SIGNATURE_UTILS.validateECDSASignature(offlineDataWithoutSignature.getBytes(StandardCharsets.UTF_8), Base64.getDecoder().decode(ecdsaSignature), (PublicKey)serverPublicKey);
            if (!dataSignatureValid) {
                stepLogger.writeError(this.getStep().id() + "-error-invalid-signature", "Invalid signature", "Invalid signature of offline data");
                stepLogger.writeDoneFailed(this.getStep().id() + "-failed");
                return null;
            }
            String dataForSignature = Stream.of(operationId, operationData, totp).filter(StringUtils::hasText).collect(Collectors.joining("&"));
            String signatureBaseString = PowerAuthHttpBody.getSignatureBaseString((String)"POST", (String)"/operation/authorize/offline", (byte[])Base64.getDecoder().decode(nonce), (byte[])dataForSignature.getBytes(StandardCharsets.UTF_8));
            byte[] signaturePossessionKeyBytes = Base64.getDecoder().decode(resultStatusObject.getSignaturePossessionKey());
            byte[] signatureKnowledgeKeySalt = Base64.getDecoder().decode(resultStatusObject.getSignatureKnowledgeKeySalt());
            byte[] signatureKnowledgeKeyEncryptedBytes = Base64.getDecoder().decode(resultStatusObject.getSignatureKnowledgeKeyEncrypted());
            SecretKey signaturePossessionKey = KEY_CONVERTOR.convertBytesToSharedSecretKey(signaturePossessionKeyBytes);
            SecretKey signatureKnowledgeKey = EncryptedStorageUtil.getSignatureKnowledgeKey(password, signatureKnowledgeKeyEncryptedBytes, signatureKnowledgeKeySalt, KEY_GENERATOR);
            ArrayList<SecretKey> signatureKeys = new ArrayList<SecretKey>();
            signatureKeys.add(signaturePossessionKey);
            signatureKeys.add(signatureKnowledgeKey);
            return SIGNATURE_UTILS.computePowerAuthSignature((signatureBaseString + "&offline").getBytes(StandardCharsets.UTF_8), signatureKeys, CounterUtil.getCtrData(resultStatusObject, stepLogger), (SignatureConfiguration)SignatureConfiguration.decimal());
        }
        catch (Exception ex) {
            stepLogger.writeError(this.getStep().id() + "-error-cryptography", "Cryptography error", ex.getMessage());
            stepLogger.writeDoneFailed(this.getStep().id() + "-failed");
            return null;
        }
    }
}

