/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps;

import com.wultra.core.rest.client.base.RestClient;
import com.wultra.core.rest.client.base.RestClientException;
import io.getlime.security.powerauth.crypto.lib.encryptor.ClientEncryptor;
import io.getlime.security.powerauth.crypto.lib.encryptor.EncryptorFactory;
import io.getlime.security.powerauth.crypto.lib.encryptor.ecies.exception.EciesException;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptedRequest;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptedResponse;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptorId;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptorParameters;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptorScope;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptorSecrets;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.v3.ClientEncryptorSecrets;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthStep;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthVersion;
import io.getlime.security.powerauth.lib.cmd.logging.DisabledStepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.StepLoggerFactory;
import io.getlime.security.powerauth.lib.cmd.status.ResultStatusService;
import io.getlime.security.powerauth.lib.cmd.steps.BaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.context.RequestContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.ResponseContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.StepContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.security.SimpleSecurityContext;
import io.getlime.security.powerauth.lib.cmd.steps.model.data.BaseStepData;
import io.getlime.security.powerauth.lib.cmd.steps.model.feature.DryRunCapable;
import io.getlime.security.powerauth.lib.cmd.steps.model.feature.ResultStatusChangeable;
import io.getlime.security.powerauth.lib.cmd.steps.pojo.ResultStatusObject;
import io.getlime.security.powerauth.lib.cmd.util.CounterUtil;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.MapUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.lib.cmd.util.RestClientFactory;
import io.getlime.security.powerauth.lib.cmd.util.SecurityUtil;
import io.getlime.security.powerauth.lib.cmd.util.TemporaryKeyUtil;
import io.getlime.security.powerauth.rest.api.model.request.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.EciesEncryptedResponse;
import jakarta.annotation.Nullable;
import java.security.PublicKey;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;

public abstract class AbstractBaseStep<M extends BaseStepData, R>
implements BaseStep {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBaseStep.class);
    private static final KeyConvertor KEY_CONVERTOR = new KeyConvertor();
    private final PowerAuthStep step;
    private final List<PowerAuthVersion> supportedVersions;
    protected final ResultStatusService resultStatusService;
    protected final StepLoggerFactory stepLoggerFactory;
    private static final EncryptorFactory ENCRYPTOR_FACTORY = new EncryptorFactory();

    public AbstractBaseStep(PowerAuthStep step, List<PowerAuthVersion> supportedVersions, ResultStatusService resultStatusService, StepLoggerFactory stepLoggerFactory) {
        this.step = step;
        this.supportedVersions = List.copyOf(supportedVersions);
        this.resultStatusService = resultStatusService;
        this.stepLoggerFactory = stepLoggerFactory;
    }

    public abstract StepContext<M, R> prepareStepContext(StepLogger var1, Map<String, Object> var2) throws Exception;

    protected abstract ParameterizedTypeReference<R> getResponseTypeReference();

    @Override
    public final ResultStatusObject execute(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        StepContext<M, R> stepContext;
        if (stepLogger == null) {
            stepLogger = DisabledStepLogger.INSTANCE;
        }
        stepLogger.writeItem(this.getStep().id() + "-start", this.getStep().description() + " Started", null, "OK", null);
        try {
            stepContext = this.prepareStepContext(stepLogger, context);
            if (stepContext == null) {
                return null;
            }
        }
        catch (EciesException e) {
            stepLogger.writeError(this.getStep().id() + "-error-encryption", (Exception)((Object)e));
            stepLogger.writeDoneFailed(this.getStep().id() + "-failed");
            return null;
        }
        try {
            ResponseContext<R> responseContext = this.callServer(stepContext);
            if (responseContext != null) {
                stepContext.setResponseContext(responseContext);
                this.processResponse(stepContext);
                stepLogger.writeDoneOK(this.getStep().id() + "-success");
            } else if (!this.isDryRun(stepContext.getModel())) {
                stepContext.getStepLogger().writeDoneFailed(this.getStep().id() + "-failed");
            }
        }
        catch (Exception exception) {
            stepLogger.writeError(this.getStep().id() + "-error-generic", exception);
            stepLogger.writeDoneFailed(this.getStep().id() + "-failed");
            return null;
        }
        JSONObject resultStatusObject = stepContext.getModel().getResultStatusObject();
        if (resultStatusObject == null) {
            return null;
        }
        return ResultStatusObject.fromJsonObject(resultStatusObject);
    }

    public void addEncryptedRequest(StepContext<M, R> stepContext, String applicationKey, String applicationSecret, EncryptorId encryptorId, byte[] data, EncryptorScope scope) throws Exception {
        ClientEncryptor encryptor;
        M model = stepContext.getModel();
        SimpleSecurityContext securityContext = (SimpleSecurityContext)stepContext.getSecurityContext();
        ResultStatusObject resultStatusObject = model.getResultStatus();
        this.fetchTemporaryKey(stepContext, scope);
        if (securityContext == null) {
            String temporaryKeyId = (String)stepContext.getAttributes().get("temporaryKeyId");
            String temporaryPublicKey = (String)stepContext.getAttributes().get("temporaryPublicKey");
            PublicKey encryptionPublicKey = temporaryKeyId == null ? resultStatusObject.getServerPublicKeyObject() : KEY_CONVERTOR.convertBytesToPublicKey(Base64.getDecoder().decode(temporaryPublicKey));
            byte[] transportMasterKeyBytes = Base64.getDecoder().decode(resultStatusObject.getTransportMasterKey());
            EncryptorParameters encryptorParameters = new EncryptorParameters(model.getVersion().value(), applicationKey, resultStatusObject.getActivationId(), temporaryKeyId);
            ClientEncryptorSecrets encryptorSecrets = new ClientEncryptorSecrets(encryptionPublicKey, applicationSecret, transportMasterKeyBytes);
            encryptor = ENCRYPTOR_FACTORY.getClientEncryptor(encryptorId, encryptorParameters, (EncryptorSecrets)encryptorSecrets);
            stepContext.setSecurityContext(SimpleSecurityContext.builder().encryptor(encryptor).build());
        } else {
            encryptor = securityContext.getEncryptor();
        }
        this.addEncryptedRequest(stepContext, encryptor, data);
    }

    public void addEncryptedRequest(StepContext<M, R> stepContext, ClientEncryptor encryptor, byte[] data) throws Exception {
        SimpleSecurityContext securityContext = (SimpleSecurityContext)stepContext.getSecurityContext();
        if (securityContext == null) {
            stepContext.setSecurityContext(SimpleSecurityContext.builder().encryptor(encryptor).build());
        } else if (securityContext.getEncryptor() != encryptor) {
            throw new Exception("Different encryptor is already set to security context");
        }
        EncryptedRequest encryptedRequest = encryptor.encryptRequest(data);
        EciesEncryptedRequest requestObject = SecurityUtil.createEncryptedRequest(encryptedRequest);
        stepContext.getRequestContext().setRequestObject(requestObject);
    }

    public void fetchTemporaryKey(StepContext<M, R> stepContext, EncryptorScope scope) throws Exception {
        TemporaryKeyUtil.fetchTemporaryKey(this.getStep(), stepContext, scope);
    }

    public <T> T decryptResponse(StepContext<?, EciesEncryptedResponse> stepContext, Class<T> cls) {
        try {
            SimpleSecurityContext securityContext = (SimpleSecurityContext)stepContext.getSecurityContext();
            EciesEncryptedResponse encryptedResponse = stepContext.getResponseContext().getResponseBodyObject();
            byte[] decryptedBytes = securityContext.getEncryptor().decryptResponse(new EncryptedResponse(encryptedResponse.getEncryptedData(), encryptedResponse.getMac(), encryptedResponse.getNonce(), encryptedResponse.getTimestamp()));
            Object responsePayload = RestClientConfiguration.defaultMapper().readValue(decryptedBytes, cls);
            stepContext.getResponseContext().setResponsePayloadDecrypted(responsePayload);
            stepContext.getStepLogger().writeItem(this.getStep().id() + "-response-decrypt", "Decrypted Response", "Following data were decrypted", "OK", responsePayload);
            return (T)responsePayload;
        }
        catch (Exception ex) {
            logger.debug(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public void processResponse(StepContext<M, R> stepContext) throws Exception {
    }

    public final void processResponse(StepContext<M, R> stepContext, byte[] responseBody, Class<R> responseObjectClass) throws Exception {
        R responseBodyObject = HttpUtil.fromBytes(responseBody, responseObjectClass);
        ResponseEntity responseEntity = ResponseEntity.ofNullable(responseBodyObject);
        this.addResponseContext(stepContext, responseEntity);
        this.processResponse(stepContext);
    }

    protected final StepContext<M, R> buildStepContext(StepLogger stepLogger, M model, RequestContext requestContext) {
        StepContext context = new StepContext();
        context.setModel(model);
        context.setRequestContext(requestContext);
        context.setStep(this.getStep());
        context.setStepLogger(stepLogger);
        return context;
    }

    protected <RS extends ResultStatusChangeable> void incrementCounter(RS model) throws Exception {
        CounterUtil.incrementCounter(model);
        this.resultStatusService.save(model);
    }

    protected void logDryRun(StepLogger stepLogger) {
        stepLogger.writeItem(this.getStep().id() + "-dry-run", "Dry run", "The request was just dry-run, no external service call", "OK", null);
    }

    @Nullable
    private ResponseContext<R> callServer(StepContext<M, R> stepContext) throws Exception {
        ResponseEntity responseEntity;
        if (stepContext == null) {
            return null;
        }
        ParameterizedTypeReference<R> responseTypeReference = this.getResponseTypeReference();
        if (responseTypeReference == null) {
            return null;
        }
        M model = stepContext.getModel();
        RequestContext requestContext = stepContext.getRequestContext();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        headers.putAll(requestContext.getHttpHeaders());
        if (model.getHeaders() != null && !model.getHeaders().isEmpty()) {
            headers.putAll(model.getHeaders());
        }
        byte[] requestBytes = HttpUtil.toRequestBytes(requestContext.getRequestObject());
        stepContext.getStepLogger().writeServerCall(this.step.id() + "-request-sent", requestContext.getUri(), requestContext.getHttpMethod().name(), requestContext.getRequestObject(), requestBytes, headers);
        if (this.isDryRun(model)) {
            this.logDryRun(stepContext.getStepLogger());
            stepContext.getStepLogger().writeDoneOK(this.getStep().id() + "-success");
            return null;
        }
        RestClient restClient = RestClientFactory.getRestClient();
        if (restClient == null) {
            stepContext.getStepLogger().writeError(this.step.id() + "-error-rest-client", "Unable to prepare a REST client");
            return null;
        }
        try {
            responseEntity = HttpMethod.GET.equals((Object)requestContext.getHttpMethod()) ? restClient.get(requestContext.getUri(), null, MapUtil.toMultiValueMap(headers), responseTypeReference) : restClient.post(requestContext.getUri(), (Object)requestBytes, null, MapUtil.toMultiValueMap(headers), responseTypeReference);
        }
        catch (RestClientException ex) {
            stepContext.getStepLogger().writeServerCallError(this.step.id() + "-error-server-call", ex.getStatusCode().value(), ex.getResponse(), HttpUtil.flattenHttpHeaders(ex.getResponseHeaders()));
            return null;
        }
        return this.addResponseContext(stepContext, responseEntity);
    }

    private ResponseContext<R> addResponseContext(StepContext<M, R> stepContext, ResponseEntity<R> responseEntity) {
        Object responseBodyObject = Objects.requireNonNull(responseEntity.getBody());
        stepContext.getStepLogger().writeServerCallOK(this.step.id() + "-response-received", responseBodyObject, HttpUtil.flattenHttpHeaders(responseEntity.getHeaders()));
        ResponseContext<Object> responseContext = ResponseContext.builder().responseBodyObject(responseBodyObject).responseEntity(responseEntity).build();
        stepContext.setResponseContext(responseContext);
        return responseContext;
    }

    private boolean isDryRun(M model) {
        return model instanceof DryRunCapable && ((DryRunCapable)model).isDryRun();
    }

    @Override
    @Generated
    public PowerAuthStep getStep() {
        return this.step;
    }

    @Override
    @Generated
    public List<PowerAuthVersion> getSupportedVersions() {
        return this.supportedVersions;
    }
}

