/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.service;

import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthStep;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthVersion;
import io.getlime.security.powerauth.lib.cmd.exception.PowerAuthCmdException;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.steps.BaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.StepProvider;
import io.getlime.security.powerauth.lib.cmd.steps.model.BaseStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.pojo.ResultStatusObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StepExecutionService {
    private final StepLogger stepLogger;
    private final StepProvider stepProvider;

    @Autowired
    public StepExecutionService(StepLogger stepLogger, StepProvider stepProvider) {
        this.stepLogger = stepLogger;
        this.stepProvider = stepProvider;
    }

    public ResultStatusObject execute(PowerAuthStep stepId, PowerAuthVersion version, BaseStepModel model) throws Exception {
        if (!this.stepProvider.exists(stepId)) {
            this.stepLogger.writeItem("generic-error-step", "Unsupported step", "The step you specified is not supported: " + String.valueOf((Object)stepId), "ERROR", null);
            throw new PowerAuthCmdException();
        }
        BaseStep step = this.stepProvider.getStep(stepId, version);
        ResultStatusObject result = step.execute(this.stepLogger, model.toMap());
        if (result == null) {
            throw new PowerAuthCmdException();
        }
        return result;
    }
}

