/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.logging;

import io.getlime.security.powerauth.lib.cmd.consts.StepLoggerType;
import io.getlime.security.powerauth.lib.cmd.logging.DisabledStepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.JsonStepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.ObjectStepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.config.StepLoggerConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StepLoggerFactory {
    private final StepLoggerConfig config;

    public StepLoggerFactory(StepLoggerType stepLoggerType) {
        this.config = new StepLoggerConfig();
        this.config.setType(stepLoggerType);
    }

    @Autowired
    public StepLoggerFactory(StepLoggerConfig config) {
        this.config = config;
    }

    public StepLogger createStepLogger() {
        if (this.config == null || this.config.getType() == null) {
            return DisabledStepLogger.INSTANCE;
        }
        return switch (this.config.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case StepLoggerType.DISABLED -> DisabledStepLogger.INSTANCE;
            case StepLoggerType.JSON -> new JsonStepLogger(System.out);
            case StepLoggerType.OBJECT -> new ObjectStepLogger(System.out);
        };
    }
}

