/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.logging;

import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.model.StepError;
import io.getlime.security.powerauth.lib.cmd.logging.model.StepItem;
import io.getlime.security.powerauth.lib.cmd.logging.model.StepRequest;
import io.getlime.security.powerauth.lib.cmd.logging.model.StepResponse;
import io.getlime.security.powerauth.lib.cmd.logging.model.StepResult;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectStepLogger
implements StepLogger {
    private final List<StepItem> items;
    private final List<StepError> errors;
    private StepRequest request;
    private StepResponse response;
    private StepResult result;
    private final OutputStream out;

    public ObjectStepLogger() {
        this(null);
    }

    public ObjectStepLogger(OutputStream out) {
        this.out = out;
        this.items = new ArrayList<StepItem>();
        this.errors = new ArrayList<StepError>();
    }

    @Override
    public void start() {
    }

    @Override
    public void writeItem(String id, String name, String description, String status, Object object) {
        this.items.add(new StepItem(id, name, description, status, object));
        if (this.out != null) {
            String output = status + ": " + id + " => " + name + (String)(description == null ? "" : " - " + description) + "\n";
            try {
                this.out.write(output.getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void writeServerCall(String id, String uri, String method, Object requestObject, byte[] requestBytes, Map<String, ?> headers) {
        if (this.request != null) {
            throw new IllegalStateException("Only one request per step is supported");
        }
        this.request = new StepRequest(uri, method, requestObject, headers);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("url", uri);
        map.put("method", method);
        map.put("requestBytes", requestBytes);
        map.put("requestObject", this.request.requestObject());
        map.put("requestHeaders", headers);
        String name = "Sending Request";
        String desc = "Calling PowerAuth Standard RESTful API endpoint";
        String status = "OK";
        this.writeItem(id, name, desc, status, map);
    }

    @Override
    public void writeServerCallOK(String id, Object responseObject, Map<String, ?> headers) {
        if (this.response != null) {
            throw new IllegalStateException("Only one response per step is supported");
        }
        this.response = new StepResponse(200, responseObject, headers);
        String name = "Response 200 - OK";
        String desc = "Endpoint was called successfully";
        String status = "OK";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("responseObject", responseObject);
        map.put("responseHeaders", headers);
        this.writeItem(id, name, desc, status, map);
    }

    @Override
    public void writeServerCallError(String id, int statusCode, Object responseObject, Map<String, ?> headers) {
        if (this.response != null) {
            throw new IllegalStateException("Only one response per step is supported");
        }
        this.response = new StepResponse(statusCode, responseObject, headers);
        String name = "Response " + statusCode + " - ERROR";
        String desc = "Endpoint was called with an error";
        String status = "ERROR";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("responseObject", responseObject);
        map.put("responseHeaders", headers);
        this.writeItem(id, name, desc, status, map);
    }

    @Override
    public void close() {
    }

    @Override
    public void writeServerCallConnectionError(String id, Exception e) {
        this.writeError(id, "Connection Error", e.getMessage(), e);
    }

    @Override
    public void writeError(String id, String errorMessage) {
        this.writeError(id, null, errorMessage, null);
    }

    @Override
    public void writeError(String id, Exception exception) {
        this.writeError(id, null, exception.getMessage(), exception);
    }

    @Override
    public void writeError(String id, String name, String errorMessage) {
        this.writeError(id, name, errorMessage, null);
    }

    @Override
    public void writeError(String id, String name, String errorMessage, Exception exception) {
        this.errors.add(new StepError(id, name, errorMessage, exception));
        String status = "ERROR";
        this.writeItem(id, name, errorMessage, status, exception);
    }

    @Override
    public void writeDoneOK(String id) {
        if (this.result != null) {
            throw new IllegalStateException("Only one result per step is supported");
        }
        if (!this.errors.isEmpty()) {
            this.writeDoneFailed(id + "-with-errors");
            return;
        }
        this.result = new StepResult(true);
        String name = "Done";
        String desc = "Execution has successfully finished";
        String status = "DONE";
        this.writeItem(id, name, desc, status, null);
    }

    @Override
    public void writeDoneFailed(String id) {
        if (this.result != null) {
            throw new IllegalStateException("Only one result per step is supported");
        }
        this.result = new StepResult(false);
        String name = "Done";
        String desc = "Execution has failed";
        String status = "FAILED";
        this.writeItem(id, name, desc, status, null);
    }

    public List<StepItem> getItems() {
        return this.items;
    }

    public StepItem getFirstItem(String id) {
        if (id == null) {
            return null;
        }
        for (StepItem item : this.items) {
            if (!id.equals(item.id())) continue;
            return item;
        }
        return null;
    }

    public StepItem getFirstItemByName(String itemName) {
        if (itemName == null) {
            return null;
        }
        for (StepItem item : this.items) {
            if (!itemName.equals(item.name())) continue;
            return item;
        }
        return null;
    }

    public List<StepError> getErrors() {
        return this.errors;
    }

    public StepError getFirstError(String id) {
        if (id == null) {
            return null;
        }
        for (StepError error : this.errors) {
            if (!id.equals(error.id())) continue;
            return error;
        }
        return null;
    }

    public StepError getFirstErrorByName(String errorName) {
        if (errorName == null) {
            return null;
        }
        for (StepError error : this.errors) {
            if (!errorName.equals(error.name())) continue;
            return error;
        }
        return null;
    }

    public StepRequest getRequest() {
        return this.request;
    }

    public StepResponse getResponse() {
        return this.response;
    }

    public StepResult getResult() {
        return this.result;
    }
}

