/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.header;

import io.getlime.security.powerauth.crypto.client.token.ClientTokenGenerator;
import io.getlime.security.powerauth.http.PowerAuthTokenHttpHeader;
import io.getlime.security.powerauth.lib.cmd.header.PowerAuthHeaderProvider;
import io.getlime.security.powerauth.lib.cmd.steps.context.RequestContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.StepContext;
import io.getlime.security.powerauth.lib.cmd.steps.model.data.TokenHeaderData;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class TokenHeaderProvider
implements PowerAuthHeaderProvider<TokenHeaderData> {
    @Override
    public void addHeader(StepContext<? extends TokenHeaderData, ?> stepContext) throws Exception {
        TokenHeaderData model = stepContext.getModel();
        RequestContext requestContext = stepContext.getRequestContext();
        String tokenId = model.getTokenId();
        byte[] tokenSecret = Base64.getDecoder().decode(model.getTokenSecret());
        ClientTokenGenerator tokenGenerator = new ClientTokenGenerator();
        String version = model.getVersion().value();
        byte[] tokenNonce = tokenGenerator.generateTokenNonce();
        byte[] tokenTimestamp = tokenGenerator.generateTokenTimestamp();
        byte[] tokenDigest = tokenGenerator.computeTokenDigest(tokenNonce, tokenTimestamp, version, tokenSecret);
        PowerAuthTokenHttpHeader header = new PowerAuthTokenHttpHeader(tokenId, Base64.getEncoder().encodeToString(tokenDigest), Base64.getEncoder().encodeToString(tokenNonce), new String(tokenTimestamp, StandardCharsets.UTF_8), version);
        String headerValue = header.buildHttpHeader();
        requestContext.setAuthorizationHeader(headerValue);
        requestContext.setAuthorizationHeaderName("X-PowerAuth-Token");
        requestContext.getHttpHeaders().put("X-PowerAuth-Token", headerValue);
    }
}

