/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.consts;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum PowerAuthStep {
    ACTIVATION_CREATE_CUSTOM("activation-create-custom", "Activation With Custom Attributes", "create-custom"),
    ACTIVATION_CREATE("activation-create", "Activation", "create"),
    ACTIVATION_PREPARE("activation-prepare", "Activation", "prepare"),
    ACTIVATION_REMOVE("activation-remove", "Activation Removal", "remove"),
    ACTIVATION_RECOVERY("activation-recovery", "Activation With Recovery Code", "create-recovery"),
    ACTIVATION_STATUS("activation-status", "Activation Status Check", "status"),
    ENCRYPT("encrypt", "Encrypt Request", "encrypt"),
    RECOVERY_CONFIRM("recovery-confirm", "Confirm Recovery Code", "confirm-recovery-code"),
    SIGN_ENCRYPT("sign-encrypt", "Sign and Encrypt Request", "sign-encrypt"),
    SIGNATURE_OFFLINE_COMPUTE("signature-offline-compute", "Compute Offline Signature", "compute-offline-signature"),
    SIGNATURE_VERIFY("signature-verify", "Signature Validation", "sign"),
    TOKEN_CREATE("token-create", "Token Create", "create-token"),
    TOKEN_ENCRYPT("token-encrypt", "Encrypt Request and Validate Token Digest", "token-encrypt"),
    TOKEN_REMOVE("token-remove", "Token Remove", "remove-token"),
    TOKEN_VALIDATE("token-validate", "Token Digest Validation", "validate-token"),
    UPGRADE_COMMIT("upgrade-commit", "Upgrade Commit", "commit-upgrade"),
    UPGRADE_START("upgrade-start", "Upgrade", "start-upgrade"),
    VAULT_UNLOCK("vault-unlock", "Vault Unlock", "unlock");

    private static final Map<String, PowerAuthStep> stepByAlias;
    private final String alias;
    private final String description;
    private final String id;

    private PowerAuthStep(String id, String description, String alias) {
        this.id = id;
        this.description = description;
        this.alias = alias;
    }

    public String alias() {
        return this.alias;
    }

    public String description() {
        return this.description;
    }

    public String id() {
        return this.id;
    }

    public static PowerAuthStep fromMethod(String value) {
        return Optional.ofNullable(stepByAlias.get(value)).orElseThrow(() -> new IllegalStateException("Unknown PowerAuth step value: " + value));
    }

    static {
        HashSet uniqueAliases = new HashSet();
        Arrays.stream(PowerAuthStep.values()).forEach(step -> {
            if (uniqueAliases.contains(step.alias)) {
                throw new IllegalStateException("Already existing step alias name: " + step.alias);
            }
            uniqueAliases.add(step.alias);
        });
        HashSet uniqueIds = new HashSet();
        Arrays.stream(PowerAuthStep.values()).forEach(step -> {
            if (uniqueIds.contains(step.id)) {
                throw new IllegalStateException("Already existing step id: " + step.id);
            }
            uniqueIds.add(step.id);
        });
        stepByAlias = Arrays.stream(PowerAuthStep.values()).collect(Collectors.toMap(step -> step.alias, Function.identity()));
    }
}

