/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.util.config;

import io.getlime.security.powerauth.lib.cmd.util.config.SdkConfiguration;
import io.getlime.security.powerauth.lib.cmd.util.config.SdkDataReader;
import io.getlime.security.powerauth.lib.cmd.util.config.SdkDataWriter;
import java.util.Base64;
import org.springframework.util.StringUtils;

public class SdkConfigurationSerializer {
    private static final byte SDK_CONFIGURATION_VERSION = 1;
    private static final byte MASTER_PUBLIC_KEY_CRYPTO_V3 = 1;

    public static String serialize(SdkConfiguration config) {
        String appKeyBase64 = config.appKeyBase64();
        String appSecretBase64 = config.appSecretBase64();
        String masterPublicKeyBase64 = config.masterPublicKeyBase64();
        if (!StringUtils.hasText((String)appKeyBase64)) {
            throw new IllegalArgumentException("Invalid application key");
        }
        if (!StringUtils.hasText((String)appSecretBase64)) {
            throw new IllegalArgumentException("Invalid application secret");
        }
        if (!StringUtils.hasText((String)masterPublicKeyBase64)) {
            throw new IllegalArgumentException("Invalid public key");
        }
        SdkDataWriter writer = new SdkDataWriter();
        writer.writeByte((byte)1);
        writer.writeData(Base64.getDecoder().decode(appKeyBase64));
        writer.writeData(Base64.getDecoder().decode(appSecretBase64));
        writer.writeCount(1);
        writer.writeByte((byte)1);
        byte[] publicKeyBytes = Base64.getDecoder().decode(masterPublicKeyBase64);
        writer.writeData(publicKeyBytes);
        return Base64.getEncoder().encodeToString(writer.getSerializedData());
    }

    public static SdkConfiguration deserialize(String serialized) {
        byte[] serializedBytes = Base64.getDecoder().decode(serialized);
        SdkDataReader reader = new SdkDataReader(serializedBytes);
        Byte version = reader.readByte();
        if (version == null || version != 1) {
            return null;
        }
        byte[] appKey = reader.readData(16);
        byte[] appSecret = reader.readData(16);
        Integer keyCount = reader.readCount();
        if (appKey == null || appSecret == null || keyCount != 1) {
            return null;
        }
        Byte keyId = reader.readByte();
        if (keyId != 1) {
            return null;
        }
        byte[] masterPublicKey = reader.readData(0);
        String appKeyBase64 = Base64.getEncoder().encodeToString(appKey);
        String appSecretBase64 = Base64.getEncoder().encodeToString(appSecret);
        String masterPublicKeyBase64 = Base64.getEncoder().encodeToString(masterPublicKey);
        return new SdkConfiguration(appKeyBase64, appSecretBase64, masterPublicKeyBase64);
    }
}

