/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.util;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.wultra.core.rest.client.base.RestClient;
import com.wultra.core.rest.client.base.RestClientException;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptorScope;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.util.HMACHashUtilities;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import io.getlime.security.powerauth.crypto.lib.util.SignatureUtils;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthStep;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthVersion;
import io.getlime.security.powerauth.lib.cmd.steps.context.StepContext;
import io.getlime.security.powerauth.lib.cmd.steps.model.BaseStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.model.data.BaseStepData;
import io.getlime.security.powerauth.lib.cmd.util.HttpUtil;
import io.getlime.security.powerauth.lib.cmd.util.MapUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientFactory;
import io.getlime.security.powerauth.rest.api.model.request.TemporaryKeyRequest;
import io.getlime.security.powerauth.rest.api.model.response.TemporaryKeyResponse;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DLSequence;
import org.springframework.util.StringUtils;

public class TemporaryKeyUtil {
    public static final String TEMPORARY_KEY_ID = "temporaryKeyId";
    public static final String TEMPORARY_PUBLIC_KEY = "temporaryPublicKey";
    private static final KeyGenerator KEY_GENERATOR = new KeyGenerator();
    private static final KeyConvertor KEY_CONVERTOR = new KeyConvertor();
    private static final SignatureUtils SIGNATURE_UTILS = new SignatureUtils();

    private TemporaryKeyUtil() {
    }

    public static void fetchTemporaryKey(PowerAuthStep step, StepContext<? extends BaseStepData, ?> stepContext, EncryptorScope scope) throws Exception {
        PowerAuthVersion version = stepContext.getModel().getVersion();
        if (!version.useTemporaryKeys() || stepContext.getAttributes().containsKey(TEMPORARY_KEY_ID)) {
            return;
        }
        RestClient restClient = RestClientFactory.getRestClient();
        if (restClient == null) {
            stepContext.getStepLogger().writeError(step.id() + "-error-rest-client", "Unable to prepare a REST client");
            return;
        }
        TemporaryKeyUtil.sendTemporaryKeyRequest(step, stepContext, scope);
    }

    private static Map<String, String> prepareHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return headers;
    }

    private static String createJwtRequest(StepContext<? extends BaseStepData, ?> stepContext, BaseStepModel model, EncryptorScope scope, String challenge) throws Exception {
        Instant now = Instant.now();
        String activationId = scope == EncryptorScope.ACTIVATION_SCOPE ? model.getResultStatus().getActivationId() : null;
        JWTClaimsSet jwtClaims = new JWTClaimsSet.Builder().claim("applicationKey", stepContext.getModel().toMap().get("APPLICATION_KEY")).claim("activationId", (Object)activationId).claim("challenge", (Object)challenge).issueTime(Date.from(now)).expirationTime(Date.from(now.plus(5L, ChronoUnit.MINUTES))).build();
        byte[] secretKey = TemporaryKeyUtil.getSecretKey(stepContext, model, scope);
        return TemporaryKeyUtil.signJwt(jwtClaims, secretKey);
    }

    private static byte[] getSecretKey(StepContext<? extends BaseStepData, ?> stepContext, BaseStepModel model, EncryptorScope scope) throws Exception {
        String appSecret = (String)stepContext.getModel().toMap().get("APPLICATION_SECRET");
        if (scope == EncryptorScope.APPLICATION_SCOPE) {
            return Base64.getDecoder().decode(appSecret);
        }
        if (scope == EncryptorScope.ACTIVATION_SCOPE) {
            byte[] appSecretBytes = Base64.getDecoder().decode(appSecret);
            SecretKey transportMasterKey = model.getResultStatus().getTransportMasterKeyObject();
            if (transportMasterKey == null) {
                stepContext.getStepLogger().writeError(stepContext.getStep().id() + "-failed", "Get Transport Master Key Failed", "transportMasterKey is null");
                return null;
            }
            SecretKey secretKeyBytes = KEY_GENERATOR.deriveSecretKeyHmac(transportMasterKey, appSecretBytes);
            return KEY_CONVERTOR.convertSharedSecretKeyToBytes(secretKeyBytes);
        }
        return null;
    }

    private static String signJwt(JWTClaimsSet jwtClaims, byte[] secretKey) throws Exception {
        JWSHeader jwsHeader = new JWSHeader(JWSAlgorithm.HS256);
        byte[] payloadBytes = jwtClaims.toPayload().toBytes();
        Base64URL encodedHeader = jwsHeader.toBase64URL();
        Base64URL encodedPayload = Base64URL.encode((byte[])payloadBytes);
        String signingInput = String.valueOf(encodedHeader) + "." + String.valueOf(encodedPayload);
        byte[] hash = new HMACHashUtilities().hash(secretKey, signingInput.getBytes(StandardCharsets.UTF_8));
        Base64URL signature = Base64URL.encode((byte[])hash);
        return String.valueOf(encodedHeader) + "." + String.valueOf(encodedPayload) + "." + String.valueOf(signature);
    }

    private static void sendTemporaryKeyRequest(PowerAuthStep step, StepContext<? extends BaseStepData, ?> stepContext, EncryptorScope scope) throws Exception {
        BaseStepModel model = (BaseStepModel)stepContext.getModel();
        Map<String, String> headers = TemporaryKeyUtil.prepareHeaders();
        String baseUri = model.getBaseUriString();
        if (!StringUtils.hasText((String)baseUri) && !StringUtils.hasText((String)(baseUri = model.getUriString()))) {
            stepContext.getStepLogger().writeError(step.id() + "-error-missing-base-uri-string", "Base URI string is required for fetching temporary keys");
            return;
        }
        String uri = baseUri + "/pa/v3/keystore/create";
        byte[] challengeBytes = KEY_GENERATOR.generateRandomBytes(18);
        String challenge = Base64.getEncoder().encodeToString(challengeBytes);
        String requestData = TemporaryKeyUtil.createJwtRequest(stepContext, model, scope, challenge);
        TemporaryKeyRequest jwtData = new TemporaryKeyRequest();
        jwtData.setJwt(requestData);
        ObjectRequest request = new ObjectRequest((Object)jwtData);
        RestClient restClient = RestClientFactory.getRestClient();
        try {
            ObjectResponse response = Objects.requireNonNull(restClient).postObject(uri, request, null, MapUtil.toMultiValueMap(headers), TemporaryKeyResponse.class);
            stepContext.getStepLogger().writeItem(step.id() + "-temporary-key-fetched", "Temporary key fetched", "Temporary key was fetched from the server", "OK", null);
            TemporaryKeyUtil.handleTemporaryKeyResponse(step, stepContext, (ObjectResponse<TemporaryKeyResponse>)response, scope);
        }
        catch (RestClientException ex) {
            stepContext.getStepLogger().writeServerCallError(step.id() + "-error-server-call", ex.getStatusCode().value(), ex.getResponse(), HttpUtil.flattenHttpHeaders(ex.getResponseHeaders()));
        }
    }

    private static void handleTemporaryKeyResponse(PowerAuthStep step, StepContext<? extends BaseStepData, ?> stepContext, ObjectResponse<TemporaryKeyResponse> response, EncryptorScope scope) throws Exception {
        ECPublicKey publicKey;
        String jwtResponse = ((TemporaryKeyResponse)response.getResponseObject()).getJwt();
        SignedJWT decodedJWT = SignedJWT.parse((String)jwtResponse);
        switch (scope) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ACTIVATION_SCOPE: {
                ECPublicKey eCPublicKey = (ECPublicKey)stepContext.getModel().getResultStatus().getServerPublicKeyObject();
                break;
            }
            case APPLICATION_SCOPE: {
                ECPublicKey eCPublicKey = publicKey = (ECPublicKey)stepContext.getModel().toMap().get("MASTER_PUBLIC_KEY");
            }
        }
        if (!TemporaryKeyUtil.validateJwtSignature(decodedJWT, publicKey)) {
            stepContext.getStepLogger().writeError(step.id() + "-error-signature-invalid", "JWT signature is invalid");
            return;
        }
        String temporaryKeyId = (String)decodedJWT.getJWTClaimsSet().getClaim("sub");
        String temporaryPublicKey = (String)decodedJWT.getJWTClaimsSet().getClaim("publicKey");
        stepContext.getAttributes().put(TEMPORARY_KEY_ID, temporaryKeyId);
        stepContext.getAttributes().put(TEMPORARY_PUBLIC_KEY, temporaryPublicKey);
    }

    private static boolean validateJwtSignature(SignedJWT jwt, PublicKey publicKey) throws Exception {
        Base64URL[] jwtParts = jwt.getParsedParts();
        Base64URL encodedHeader = jwtParts[0];
        Base64URL encodedPayload = jwtParts[1];
        Base64URL encodedSignature = jwtParts[2];
        String signingInput = String.valueOf(encodedHeader) + "." + String.valueOf(encodedPayload);
        byte[] signatureBytes = TemporaryKeyUtil.convertRawSignatureToDER(encodedSignature.decode());
        return SIGNATURE_UTILS.validateECDSASignature(signingInput.getBytes(StandardCharsets.UTF_8), signatureBytes, publicKey);
    }

    private static byte[] convertRawSignatureToDER(byte[] rawSignature) throws Exception {
        if (rawSignature.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid ECDSA signature format");
        }
        int len = rawSignature.length / 2;
        byte[] rBytes = new byte[len];
        byte[] sBytes = new byte[len];
        System.arraycopy(rawSignature, 0, rBytes, 0, len);
        System.arraycopy(rawSignature, len, sBytes, 0, len);
        BigInteger r = new BigInteger(1, rBytes);
        BigInteger s = new BigInteger(1, sBytes);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(r));
        v.add((ASN1Encodable)new ASN1Integer(s));
        return new DLSequence(v).getEncoded();
    }
}

