/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps.v3;

import io.getlime.security.powerauth.crypto.lib.encryptor.ClientEncryptor;
import io.getlime.security.powerauth.crypto.lib.encryptor.EncryptorFactory;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptorId;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptorParameters;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptorScope;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptorSecrets;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.v3.ClientEncryptorSecrets;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import io.getlime.security.powerauth.http.PowerAuthEncryptionHttpHeader;
import io.getlime.security.powerauth.lib.cmd.consts.BackwardCompatibilityConst;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthConst;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthStep;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthVersion;
import io.getlime.security.powerauth.lib.cmd.logging.StepLogger;
import io.getlime.security.powerauth.lib.cmd.logging.StepLoggerFactory;
import io.getlime.security.powerauth.lib.cmd.status.ResultStatusService;
import io.getlime.security.powerauth.lib.cmd.steps.AbstractBaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.context.RequestContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.StepContext;
import io.getlime.security.powerauth.lib.cmd.steps.model.EncryptStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.pojo.ResultStatusObject;
import io.getlime.security.powerauth.lib.cmd.util.SecurityUtil;
import io.getlime.security.powerauth.rest.api.model.response.EciesEncryptedResponse;
import java.security.PublicKey;
import java.util.Base64;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Component;

@Component(value="encryptStepV3")
public class EncryptStep
extends AbstractBaseStep<EncryptStepModel, EciesEncryptedResponse> {
    private static final EncryptorFactory ENCRYPTOR_FACTORY = new EncryptorFactory();
    private static final KeyConvertor KEY_CONVERTOR = new KeyConvertor();

    @Autowired
    public EncryptStep(ResultStatusService resultStatusService, StepLoggerFactory stepLoggerFactory) {
        super(PowerAuthStep.ENCRYPT, PowerAuthVersion.VERSION_3, resultStatusService, stepLoggerFactory);
    }

    public EncryptStep() {
        this(BackwardCompatibilityConst.RESULT_STATUS_SERVICE, BackwardCompatibilityConst.STEP_LOGGER_FACTORY);
    }

    @Override
    protected ParameterizedTypeReference<EciesEncryptedResponse> getResponseTypeReference() {
        return PowerAuthConst.RESPONSE_TYPE_REFERENCE_V3;
    }

    @Override
    public StepContext<EncryptStepModel, EciesEncryptedResponse> prepareStepContext(StepLogger stepLogger, Map<String, Object> context) throws Exception {
        PowerAuthEncryptionHttpHeader header;
        ClientEncryptor encryptor;
        EncryptorScope scope;
        EncryptStepModel model = new EncryptStepModel();
        model.fromMap(context);
        RequestContext requestContext = RequestContext.builder().uri(model.getUriString()).build();
        StepContext<EncryptStepModel, EciesEncryptedResponse> stepContext = this.buildStepContext(stepLogger, model, requestContext);
        byte[] requestDataBytes = model.getData();
        if (requestDataBytes == null) {
            stepLogger.writeError("encrypt-error-file", "Encrypt Request Failed", "Request data for encryption was null.");
            stepLogger.writeDoneFailed("encrypt-failed");
            return null;
        }
        stepLogger.writeItem(this.getStep().id() + "-request-encrypt", "Preparing Request Data", "Following data will be encrypted", "OK", requestDataBytes);
        switch (model.getScope()) {
            case "activation": {
                EncryptorScope encryptorScope = EncryptorScope.ACTIVATION_SCOPE;
                break;
            }
            case "application": {
                EncryptorScope encryptorScope = EncryptorScope.APPLICATION_SCOPE;
                break;
            }
            default: {
                EncryptorScope encryptorScope = scope = null;
            }
        }
        if (scope == null) {
            stepLogger.writeError("encrypt-error-scope", "Encrypt Request Failed", "Unsupported encryption scope: " + model.getScope());
            stepLogger.writeDoneFailed("encrypt-failed");
            return null;
        }
        this.fetchTemporaryKey(stepContext, scope);
        String temporaryKeyId = (String)stepContext.getAttributes().get("temporaryKeyId");
        String temporaryPublicKey = (String)stepContext.getAttributes().get("temporaryPublicKey");
        switch (scope) {
            case APPLICATION_SCOPE: {
                PublicKey encryptionPublicKey = temporaryPublicKey == null ? model.getMasterPublicKey() : KEY_CONVERTOR.convertBytesToPublicKey(Base64.getDecoder().decode(temporaryPublicKey));
                EncryptorId encryptorId = EncryptorId.APPLICATION_SCOPE_GENERIC;
                EncryptorParameters encryptorParameters = new EncryptorParameters(model.getVersion().value(), model.getApplicationKey(), null, temporaryKeyId);
                ClientEncryptorSecrets encryptorSecrets = new ClientEncryptorSecrets(encryptionPublicKey, model.getApplicationSecret());
                encryptor = ENCRYPTOR_FACTORY.getClientEncryptor(encryptorId, encryptorParameters, (EncryptorSecrets)encryptorSecrets);
                header = new PowerAuthEncryptionHttpHeader(model.getApplicationKey(), model.getVersion().value());
                break;
            }
            case ACTIVATION_SCOPE: {
                ResultStatusObject resultStatusObject = model.getResultStatus();
                PublicKey encryptionPublicKey = temporaryPublicKey == null ? resultStatusObject.getServerPublicKeyObject() : KEY_CONVERTOR.convertBytesToPublicKey(Base64.getDecoder().decode(temporaryPublicKey));
                EncryptorId encryptorId = EncryptorId.ACTIVATION_SCOPE_GENERIC;
                encryptor = ENCRYPTOR_FACTORY.getClientEncryptor(encryptorId, new EncryptorParameters(model.getVersion().value(), model.getApplicationKey(), resultStatusObject.getActivationId(), temporaryKeyId), (EncryptorSecrets)new ClientEncryptorSecrets(encryptionPublicKey, model.getApplicationSecret(), org.bouncycastle.util.encoders.Base64.decode((String)resultStatusObject.getTransportMasterKey())));
                String activationId = model.getResultStatus().getActivationId();
                header = new PowerAuthEncryptionHttpHeader(model.getApplicationKey(), activationId, model.getVersion().value());
                break;
            }
            default: {
                stepLogger.writeError("encrypt-error-scope", "Encrypt Request Failed", "Unsupported encryption scope: " + model.getScope());
                stepLogger.writeDoneFailed("encrypt-failed");
                return null;
            }
        }
        this.addEncryptedRequest(stepContext, encryptor, requestDataBytes);
        String headerValue = header.buildHttpHeader();
        requestContext.setAuthorizationHeader(headerValue);
        requestContext.getHttpHeaders().put("X-PowerAuth-Encryption", headerValue);
        stepLogger.writeItem(this.getStep().id() + "-request-encrypt", "Encrypting Request Data", "Following data is sent to intermediate server", "OK", requestContext.getRequestObject());
        return stepContext;
    }

    @Override
    public void processResponse(StepContext<EncryptStepModel, EciesEncryptedResponse> stepContext) throws Exception {
        SecurityUtil.processEncryptedResponse(stepContext, this.getStep().id());
    }
}

