/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.steps;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.getlime.security.powerauth.crypto.client.activation.PowerAuthClientActivation;
import io.getlime.security.powerauth.crypto.client.keyfactory.PowerAuthClientKeyFactory;
import io.getlime.security.powerauth.crypto.client.vault.PowerAuthClientVault;
import io.getlime.security.powerauth.crypto.lib.encryptor.ClientEncryptor;
import io.getlime.security.powerauth.crypto.lib.encryptor.EncryptorFactory;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptedRequest;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptedResponse;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptorId;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptorParameters;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptorScope;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptorSecrets;
import io.getlime.security.powerauth.crypto.lib.encryptor.model.v3.ClientEncryptorSecrets;
import io.getlime.security.powerauth.crypto.lib.generator.KeyGenerator;
import io.getlime.security.powerauth.crypto.lib.util.KeyConvertor;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthConst;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthStep;
import io.getlime.security.powerauth.lib.cmd.consts.PowerAuthVersion;
import io.getlime.security.powerauth.lib.cmd.logging.StepLoggerFactory;
import io.getlime.security.powerauth.lib.cmd.status.ResultStatusService;
import io.getlime.security.powerauth.lib.cmd.steps.AbstractBaseStep;
import io.getlime.security.powerauth.lib.cmd.steps.context.StepContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.security.ActivationSecurityContext;
import io.getlime.security.powerauth.lib.cmd.steps.model.PrepareActivationStepModel;
import io.getlime.security.powerauth.lib.cmd.steps.model.data.ActivationData;
import io.getlime.security.powerauth.lib.cmd.steps.pojo.ResultStatusObject;
import io.getlime.security.powerauth.lib.cmd.util.EncryptedStorageUtil;
import io.getlime.security.powerauth.lib.cmd.util.RestClientConfiguration;
import io.getlime.security.powerauth.lib.cmd.util.SecurityUtil;
import io.getlime.security.powerauth.rest.api.model.request.ActivationLayer1Request;
import io.getlime.security.powerauth.rest.api.model.request.ActivationLayer2Request;
import io.getlime.security.powerauth.rest.api.model.request.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.ActivationLayer1Response;
import io.getlime.security.powerauth.rest.api.model.response.ActivationLayer2Response;
import io.getlime.security.powerauth.rest.api.model.response.EciesEncryptedResponse;
import java.io.Console;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.util.Assert;

public abstract class AbstractActivationStep<M extends ActivationData>
extends AbstractBaseStep<M, EciesEncryptedResponse> {
    private static final PowerAuthClientActivation ACTIVATION = new PowerAuthClientActivation();
    private static final EncryptorFactory ENCRYPTOR_FACTORY = new EncryptorFactory();
    private static final KeyConvertor KEY_CONVERTOR = new KeyConvertor();
    private static final PowerAuthClientKeyFactory KEY_FACTORY = new PowerAuthClientKeyFactory();
    private static final KeyGenerator KEY_GENERATOR = new KeyGenerator();
    private static final PowerAuthClientVault VAULT = new PowerAuthClientVault();
    private static final ObjectMapper MAPPER = RestClientConfiguration.defaultMapper();

    public AbstractActivationStep(PowerAuthStep step, List<PowerAuthVersion> supportedVersions, ResultStatusService resultStatusService, StepLoggerFactory stepLoggerFactory) {
        super(step, supportedVersions, resultStatusService, stepLoggerFactory);
    }

    @Override
    public void processResponse(StepContext<M, EciesEncryptedResponse> stepContext) throws Exception {
        EciesEncryptedResponse encryptedResponseL1 = stepContext.getResponseContext().getResponseBodyObject();
        ActivationData model = (ActivationData)stepContext.getModel();
        ActivationSecurityContext securityContext = (ActivationSecurityContext)stepContext.getSecurityContext();
        ResultStatusObject resultStatusObject = this.processResponse(encryptedResponseL1, stepContext);
        model.setResultStatus(resultStatusObject);
        this.resultStatusService.save(model);
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        objectMap.put("activationId", resultStatusObject.getActivationId());
        objectMap.put("activationStatusFile", model.getStatusFileName());
        objectMap.put("activationStatusFileContent", model.getResultStatus());
        objectMap.put("deviceKeyFingerprint", ACTIVATION.computeActivationFingerprint(securityContext.getDeviceKeyPair().getPublic(), resultStatusObject.getServerPublicKeyObject(), resultStatusObject.getActivationId()));
        stepContext.getStepLogger().writeItem(this.getStep().id() + "-custom-activation-done", "Activation Done", "Public key exchange was successfully completed, commit the activation on server if required", "OK", objectMap);
    }

    public ResultStatusObject processResponse(EciesEncryptedResponse encryptedResponseL1, StepContext<M, EciesEncryptedResponse> context) throws Exception {
        char[] password;
        ActivationData model = (ActivationData)context.getModel();
        ActivationSecurityContext securityContext = (ActivationSecurityContext)context.getSecurityContext();
        byte[] decryptedDataL1 = securityContext.getEncryptorL1().decryptResponse(new EncryptedResponse(encryptedResponseL1.getEncryptedData(), encryptedResponseL1.getMac(), encryptedResponseL1.getNonce(), encryptedResponseL1.getTimestamp()));
        ActivationLayer1Response responseL1 = (ActivationLayer1Response)MAPPER.readValue(decryptedDataL1, ActivationLayer1Response.class);
        context.getStepLogger().writeItem(this.getStep().id() + "-response-decrypt", "Decrypted Layer 1 Response", "Following layer 1 activation data were decrypted", "OK", responseL1);
        EciesEncryptedResponse encryptedResponseL2 = responseL1.getActivationData();
        byte[] decryptedDataL2 = securityContext.getEncryptorL2().decryptResponse(new EncryptedResponse(encryptedResponseL2.getEncryptedData(), encryptedResponseL2.getMac(), encryptedResponseL2.getNonce(), encryptedResponseL2.getTimestamp()));
        ActivationLayer2Response responseL2 = (ActivationLayer2Response)MAPPER.readValue(decryptedDataL2, ActivationLayer2Response.class);
        context.getStepLogger().writeItem(this.getStep().id() + "-response-decrypt-inner", "Decrypted Layer 2 Response", "Following layer 2 activation data were decrypted", "OK", responseL2);
        String activationId = responseL2.getActivationId();
        String ctrDataBase64 = responseL2.getCtrData();
        String serverPublicKeyBase64 = responseL2.getServerPublicKey();
        PublicKey serverPublicKey = KEY_CONVERTOR.convertBytesToPublicKey(Base64.getDecoder().decode(serverPublicKeyBase64));
        SecretKey masterSecretKey = KEY_FACTORY.generateClientMasterSecretKey(securityContext.getDeviceKeyPair().getPrivate(), serverPublicKey);
        SecretKey signaturePossessionSecretKey = KEY_FACTORY.generateClientSignaturePossessionKey(masterSecretKey);
        SecretKey signatureKnowledgeSecretKey = KEY_FACTORY.generateClientSignatureKnowledgeKey(masterSecretKey);
        SecretKey signatureBiometrySecretKey = KEY_FACTORY.generateClientSignatureBiometryKey(masterSecretKey);
        SecretKey transportMasterKey = KEY_FACTORY.generateServerTransportKey(masterSecretKey);
        SecretKey vaultUnlockMasterKey = KEY_FACTORY.generateServerEncryptedVaultKey(masterSecretKey);
        byte[] encryptedDevicePrivateKey = VAULT.encryptDevicePrivateKey(securityContext.getDeviceKeyPair().getPrivate(), vaultUnlockMasterKey);
        if (model.getPassword() == null) {
            Console console = System.console();
            password = console.readPassword("Select a password to encrypt the knowledge related key: ", new Object[0]);
            Assert.state((password != null ? 1 : 0) != 0, (String)"Not able to read a password from the console");
        } else {
            password = model.getPassword().toCharArray();
        }
        byte[] salt = KEY_GENERATOR.generateRandomBytes(16);
        byte[] cSignatureKnowledgeSecretKey = EncryptedStorageUtil.storeSignatureKnowledgeKey(password, signatureKnowledgeSecretKey, salt, KEY_GENERATOR);
        ResultStatusObject resultStatusObject = model.getResultStatus();
        resultStatusObject.setActivationId(activationId);
        resultStatusObject.setCounter(0L);
        resultStatusObject.setCtrData(ctrDataBase64);
        resultStatusObject.setEncryptedDevicePrivateKeyBytes(encryptedDevicePrivateKey);
        resultStatusObject.setServerPublicKeyObject(serverPublicKey);
        resultStatusObject.setSignatureBiometryKeyObject(signatureBiometrySecretKey);
        resultStatusObject.setSignatureKnowledgeKeyEncryptedBytes(cSignatureKnowledgeSecretKey);
        resultStatusObject.setSignatureKnowledgeKeySaltBytes(salt);
        resultStatusObject.setSignaturePossessionKeyObject(signaturePossessionSecretKey);
        resultStatusObject.setTransportMasterKeyObject(transportMasterKey);
        resultStatusObject.setVersion(3L);
        return resultStatusObject;
    }

    protected abstract ActivationLayer1Request prepareLayer1Request(StepContext<M, EciesEncryptedResponse> var1, EciesEncryptedRequest var2);

    @Override
    protected ParameterizedTypeReference<EciesEncryptedResponse> getResponseTypeReference() {
        return PowerAuthConst.RESPONSE_TYPE_REFERENCE_V3;
    }

    protected void addEncryptedRequest(StepContext<M, EciesEncryptedResponse> stepContext) throws Exception {
        Map<String, Object> customAttributes;
        ActivationData model = (ActivationData)stepContext.getModel();
        this.fetchTemporaryKey(stepContext, EncryptorScope.APPLICATION_SCOPE);
        String temporaryPublicKey = (String)stepContext.getAttributes().get("temporaryPublicKey");
        PublicKey encryptionPublicKey = temporaryPublicKey == null ? model.getMasterPublicKey() : KEY_CONVERTOR.convertBytesToPublicKey(Base64.getDecoder().decode(temporaryPublicKey));
        ClientEncryptor clientEncryptorL1 = ENCRYPTOR_FACTORY.getClientEncryptor(EncryptorId.APPLICATION_SCOPE_GENERIC, new EncryptorParameters(model.getVersion().value(), model.getApplicationKey(), null, (String)stepContext.getAttributes().get("temporaryKeyId")), (EncryptorSecrets)new ClientEncryptorSecrets(encryptionPublicKey, model.getApplicationSecret()));
        ClientEncryptor clientEncryptorL2 = ENCRYPTOR_FACTORY.getClientEncryptor(EncryptorId.ACTIVATION_LAYER_2, new EncryptorParameters(model.getVersion().value(), model.getApplicationKey(), null, (String)stepContext.getAttributes().get("temporaryKeyId")), (EncryptorSecrets)new ClientEncryptorSecrets(encryptionPublicKey, model.getApplicationSecret()));
        KeyPair deviceKeyPair = ACTIVATION.generateDeviceKeyPair();
        ActivationSecurityContext securityContext = ActivationSecurityContext.builder().encryptorL1(clientEncryptorL1).encryptorL2(clientEncryptorL2).deviceKeyPair(deviceKeyPair).build();
        stepContext.setSecurityContext(securityContext);
        Map<String, String> identityAttributes = model.getIdentityAttributes();
        if (identityAttributes != null && !identityAttributes.isEmpty()) {
            stepContext.getStepLogger().writeItem(this.getStep().id() + "-identity-attributes", "Identity Attributes", "Following attributes are used to authenticate user", "OK", identityAttributes);
        }
        if ((customAttributes = model.getCustomAttributes()) != null && !customAttributes.isEmpty()) {
            stepContext.getStepLogger().writeItem(this.getStep().id() + "-custom-attributes", "Custom Attributes", "Following attributes are used as custom attributes for the request", "OK", customAttributes);
        }
        byte[] devicePublicKeyBytes = KEY_CONVERTOR.convertPublicKeyToBytes(securityContext.getDeviceKeyPair().getPublic());
        String devicePublicKeyBase64 = Base64.getEncoder().encodeToString(devicePublicKeyBytes);
        ActivationLayer2Request requestL2 = new ActivationLayer2Request();
        requestL2.setActivationName(model.getActivationName());
        if (model instanceof PrepareActivationStepModel) {
            requestL2.setActivationOtp(((PrepareActivationStepModel)model).getAdditionalActivationOtp());
        }
        requestL2.setDevicePublicKey(devicePublicKeyBase64);
        requestL2.setPlatform(model.getPlatform());
        requestL2.setDeviceInfo(model.getDeviceInfo());
        EncryptedRequest encryptedRequestL2 = SecurityUtil.encryptObject(clientEncryptorL2, requestL2);
        EciesEncryptedRequest encryptedObjectL2 = SecurityUtil.createEncryptedRequest(encryptedRequestL2);
        ActivationLayer1Request requestL1 = this.prepareLayer1Request(stepContext, encryptedObjectL2);
        stepContext.getStepLogger().writeItem(this.getStep().id() + "-request-encrypt", "Building activation request object", "Following activation attributes will be encrypted and sent to the server", "OK", requestL1);
        EncryptedRequest encryptedRequestL1 = SecurityUtil.encryptObject(clientEncryptorL1, requestL1);
        EciesEncryptedRequest encryptedRequestObjectL1 = SecurityUtil.createEncryptedRequest(encryptedRequestL1);
        stepContext.getRequestContext().setRequestObject(encryptedRequestObjectL1);
    }
}

