/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.header;

import io.getlime.security.powerauth.crypto.lib.encryptor.model.EncryptorScope;
import io.getlime.security.powerauth.http.PowerAuthEncryptionHttpHeader;
import io.getlime.security.powerauth.lib.cmd.header.PowerAuthHeaderProvider;
import io.getlime.security.powerauth.lib.cmd.steps.context.RequestContext;
import io.getlime.security.powerauth.lib.cmd.steps.context.StepContext;
import io.getlime.security.powerauth.lib.cmd.steps.model.data.EncryptionHeaderData;

public class EncryptionHeaderProvider
implements PowerAuthHeaderProvider<EncryptionHeaderData> {
    @Override
    public void addHeader(StepContext<? extends EncryptionHeaderData, ?> stepContext) {
        EncryptionHeaderData model = stepContext.getModel();
        EncryptorScope encryptorScope = stepContext.getSecurityContext().getEncryptorScope();
        if (encryptorScope == null) {
            throw new IllegalStateException("Scope is not determined yet. To fix this, move call to addHeader() after addEncryptedRequest call.");
        }
        String activationId = encryptorScope == EncryptorScope.ACTIVATION_SCOPE ? model.getResultStatus().getActivationId() : null;
        PowerAuthEncryptionHttpHeader header = new PowerAuthEncryptionHttpHeader(model.getApplicationKey(), activationId, model.getVersion().value());
        String headerValue = header.buildHttpHeader();
        RequestContext requestContext = stepContext.getRequestContext();
        requestContext.setAuthorizationHeader(headerValue);
        requestContext.setAuthorizationHeaderName("X-PowerAuth-Encryption");
        requestContext.getHttpHeaders().put("X-PowerAuth-Encryption", headerValue);
    }
}

