/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.cmd.consts;

import java.util.Arrays;
import java.util.List;

public enum PowerAuthVersion {
    V3_0(3, "3.0"),
    V3_1(3, "3.1"),
    V3_2(3, "3.2"),
    V3_3(3, "3.3");

    public static final List<PowerAuthVersion> ALL_VERSIONS;
    public static final PowerAuthVersion DEFAULT;
    public static final List<PowerAuthVersion> VERSION_3;
    private final int majorVersion;
    private final String value;

    private PowerAuthVersion(int majorVersion, String versionValue) {
        this.majorVersion = majorVersion;
        this.value = versionValue;
    }

    public boolean useIv() {
        return this.majorVersion >= 3 && !V3_0.equals((Object)this);
    }

    public boolean useDifferentIvForResponse() {
        return this.majorVersion >= 3 && !V3_0.equals((Object)this) && !V3_1.equals((Object)this);
    }

    public boolean useTimestamp() {
        return this.majorVersion >= 3 && !V3_0.equals((Object)this) && !V3_1.equals((Object)this);
    }

    public boolean useTemporaryKeys() {
        return this.majorVersion >= 3 && !V3_0.equals((Object)this) && !V3_1.equals((Object)this) && !V3_2.equals((Object)this);
    }

    public String value() {
        return this.value;
    }

    public static PowerAuthVersion fromValue(String value) {
        return Arrays.stream(PowerAuthVersion.values()).filter(version -> version.value.equals(value)).findFirst().orElseThrow(() -> new IllegalStateException("Unsupported PowerAuth version: " + value));
    }

    static {
        ALL_VERSIONS = List.of(PowerAuthVersion.values());
        DEFAULT = V3_3;
        VERSION_3 = List.of(V3_0, V3_1, V3_2, V3_3);
    }
}

