/*
 * Decompiled with CFR 0.152.
 */
package kyo.scheduler;

import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.LongAdder;
import kyo.scheduler.InternalClock;
import kyo.scheduler.Queue;
import kyo.scheduler.Task;
import kyo.scheduler.Task$;
import kyo.scheduler.Worker$;
import kyo.scheduler.Worker$internal$;
import kyo.scheduler.WorkerStatus;
import kyo.scheduler.WorkerStatus$;
import kyo.scheduler.package$;
import kyo.stats.internal.MetricReceiver;
import kyo.stats.internal.MetricReceiver$;
import kyo.stats.internal.UnsafeGauge;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public abstract class Worker
implements Runnable {
    private final int id;
    private final Executor exec;
    private final Function2<Task, Worker, BoxedUnit> scheduleTask;
    private final Function1<Worker, Task> stealTask;
    private final InternalClock clock;
    private final long a1;
    private final long a2;
    private final long a3;
    private final long a4;
    private final long a5;
    private final long a6;
    private final long a7;
    private volatile boolean running;
    private volatile Thread mount;
    private final long b1;
    private final long b2;
    private final long b3;
    private final long b4;
    private final long b5;
    private final long b6;
    private final long b7;
    private volatile long currentCycle;
    private final long c1;
    private final long c2;
    private final long c3;
    private final long c4;
    private final long c5;
    private final long c6;
    private final long c7;
    private volatile Task currentTask;
    private long executions;
    private long preemptions;
    private long completions;
    private long mounts;
    private long stolenTasks;
    private final LongAdder lostTasks;
    private final Queue<Task> queue;
    private final Function1<Task, BoxedUnit> schedule;

    public static Worker current() {
        return Worker$.MODULE$.current();
    }

    public Worker(int id, Executor exec, Function2<Task, Worker, BoxedUnit> scheduleTask, Function1<Worker, Task> stealTask, InternalClock clock) {
        this.id = id;
        this.exec = exec;
        this.scheduleTask = scheduleTask;
        this.stealTask = stealTask;
        this.clock = clock;
        this.a1 = 0L;
        this.a2 = 0L;
        this.a3 = 0L;
        this.a4 = 0L;
        this.a5 = 0L;
        this.a6 = 0L;
        this.a7 = 0L;
        this.running = false;
        this.mount = null;
        this.b1 = 0L;
        this.b2 = 0L;
        this.b3 = 0L;
        this.b4 = 0L;
        this.b5 = 0L;
        this.b6 = 0L;
        this.b7 = 0L;
        this.currentCycle = 0L;
        this.c1 = 0L;
        this.c2 = 0L;
        this.c3 = 0L;
        this.c4 = 0L;
        this.c5 = 0L;
        this.c6 = 0L;
        this.c7 = 0L;
        this.currentTask = null;
        this.executions = 0L;
        this.preemptions = 0L;
        this.completions = 0L;
        this.mounts = 0L;
        this.stolenTasks = 0L;
        this.lostTasks = new LongAdder();
        this.queue = new Queue<Task>(Task$.MODULE$.taskOrdering());
        this.schedule = (JProcedure1 & Serializable)_$1 -> scheduleTask.apply(_$1, (Object)this);
        this.registerStats();
    }

    public abstract boolean shouldStop();

    public abstract long getCurrentCycle();

    public long a1() {
        return this.a1;
    }

    public long a2() {
        return this.a2;
    }

    public long a3() {
        return this.a3;
    }

    public long a4() {
        return this.a4;
    }

    public long a5() {
        return this.a5;
    }

    public long a6() {
        return this.a6;
    }

    public long a7() {
        return this.a7;
    }

    public long b1() {
        return this.b1;
    }

    public long b2() {
        return this.b2;
    }

    public long b3() {
        return this.b3;
    }

    public long b4() {
        return this.b4;
    }

    public long b5() {
        return this.b5;
    }

    public long b6() {
        return this.b6;
    }

    public long b7() {
        return this.b7;
    }

    public long c1() {
        return this.c1;
    }

    public long c2() {
        return this.c2;
    }

    public long c3() {
        return this.c3;
    }

    public long c4() {
        return this.c4;
    }

    public long c5() {
        return this.c5;
    }

    public long c6() {
        return this.c6;
    }

    public long c7() {
        return this.c7;
    }

    private Queue<Task> queue() {
        return this.queue;
    }

    public boolean enqueue(long cycle, Task task, boolean force) {
        boolean proceed;
        boolean bl = proceed = force || this.checkAvailability(cycle);
        if (proceed) {
            this.queue().add(task);
            this.wakeup();
        }
        return proceed;
    }

    public boolean enqueue$default$3() {
        return false;
    }

    public void wakeup() {
        if (!this.running && Worker$internal$.MODULE$.runningHandle().compareAndSet(this, false, true)) {
            this.exec.execute(this);
            return;
        }
    }

    public int load() {
        int load = this.queue().size();
        if (this.currentTask != null) {
            ++load;
        }
        return load;
    }

    public Task stealingBy(Worker thief) {
        Task task = this.queue().stealingBy(thief.queue());
        if (task != null) {
            this.lostTasks.add(Int$.MODULE$.int2long(thief.queue().size() + 1));
        }
        return task;
    }

    public void drain() {
        if (!this.queue().isEmpty()) {
            this.queue().drain(this.schedule);
            return;
        }
    }

    public void cycle(long cycles) {
        Task task = this.currentTask;
        if (task != null && this.currentCycle < cycles - 1L) {
            task.doPreempt();
        }
        this.checkAvailability(cycles);
    }

    public boolean checkAvailability(long cycles) {
        boolean available;
        boolean bl = available = !this.isStalled(cycles) && !this.isBlocked();
        if (!available) {
            this.drain();
        }
        return available;
    }

    private boolean isStalled(long cycles) {
        return this.running && this.currentCycle < cycles - 2L;
    }

    private boolean isBlocked() {
        int state;
        Thread mount;
        return this.running && (mount = this.mount) != null && ((state = mount.getState().ordinal()) == Thread.State.BLOCKED.ordinal() || state == Thread.State.WAITING.ordinal() || state == Thread.State.TIMED_WAITING.ordinal());
    }

    @Override
    public void run() {
        ++this.mounts;
        this.mount = Thread.currentThread();
        Worker$internal$.MODULE$.setCurrent(this);
        Task task = null;
        while (true) {
            long cycle = this.getCurrentCycle();
            if (this.currentCycle != cycle) {
                this.currentCycle = cycle;
            }
            if (task == null) {
                task = this.queue().poll();
            }
            if (task == null && (task = (Task)this.stealTask.apply((Object)this)) != null) {
                this.stolenTasks += (long)(this.queue().size() + 1);
            }
            if (task != null) {
                ++this.executions;
                if (this.runTask(task) == Task$.MODULE$.Preempted()) {
                    ++this.preemptions;
                    task = this.queue().addAndPoll(task);
                } else {
                    ++this.completions;
                    task = null;
                }
            } else {
                this.running = false;
                if (this.queue().isEmpty() || !Worker$internal$.MODULE$.runningHandle().compareAndSet(this, false, true)) {
                    this.mount = null;
                    Worker$internal$.MODULE$.clearCurrent();
                    return;
                }
            }
            if (!this.shouldStop()) continue;
            this.running = false;
            if (task != null) {
                this.schedule.apply((Object)task);
            }
            this.drain();
            return;
        }
    }

    private boolean runTask(Task task) {
        boolean bl;
        block6: {
            this.currentTask = task;
            long start = this.clock.currentMillis();
            try {
                try {
                    bl = task.run(start, this.clock);
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(ex)) {
                        Thread thread = Thread.currentThread();
                        thread.getUncaughtExceptionHandler().uncaughtException(thread, ex);
                        bl = Task$.MODULE$.Done();
                        break block6;
                    }
                    throw throwable;
                }
            }
            finally {
                this.currentTask = null;
                task.addRuntime((int)(this.clock.currentMillis() - start));
            }
        }
        return bl;
    }

    private UnsafeGauge registerStats() {
        List<String> scope = package$.MODULE$.statsScope((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"worker", BoxesRunTime.boxToInteger((int)this.id).toString()}));
        MetricReceiver receiver = MetricReceiver$.MODULE$.get();
        receiver.gauge(scope, "executions", receiver.gauge$default$3(), receiver.gauge$default$4(), receiver.gauge$default$5(), (Function0<Object>)((Function0 & Serializable)this::registerStats$$anonfun$1));
        receiver.gauge(scope, "preemptions", receiver.gauge$default$3(), receiver.gauge$default$4(), receiver.gauge$default$5(), (Function0<Object>)((Function0 & Serializable)this::registerStats$$anonfun$2));
        receiver.gauge(scope, "completions", receiver.gauge$default$3(), receiver.gauge$default$4(), receiver.gauge$default$5(), (Function0<Object>)((Function0 & Serializable)this::registerStats$$anonfun$3));
        receiver.gauge(scope, "queue_size", receiver.gauge$default$3(), receiver.gauge$default$4(), receiver.gauge$default$5(), (Function0<Object>)((Function0 & Serializable)this::registerStats$$anonfun$4));
        receiver.gauge(scope, "current_cycle", receiver.gauge$default$3(), receiver.gauge$default$4(), receiver.gauge$default$5(), (Function0<Object>)((Function0 & Serializable)this::registerStats$$anonfun$5));
        receiver.gauge(scope, "mounts", receiver.gauge$default$3(), receiver.gauge$default$4(), receiver.gauge$default$5(), (Function0<Object>)((Function0 & Serializable)this::registerStats$$anonfun$6));
        receiver.gauge(scope, "stolen_tasks", receiver.gauge$default$3(), receiver.gauge$default$4(), receiver.gauge$default$5(), (Function0<Object>)((Function0 & Serializable)this::registerStats$$anonfun$7));
        return receiver.gauge(scope, "lost_tasks", receiver.gauge$default$3(), receiver.gauge$default$4(), receiver.gauge$default$5(), (Function0<Object>)((Function0 & Serializable)this::registerStats$$anonfun$8));
    }

    public WorkerStatus status() {
        Tuple2 tuple2;
        Task.Status status;
        Task task = this.currentTask;
        if (task == null) {
            status = null;
        } else {
            Task task2 = task;
            status = task2.status();
        }
        Task.Status taskStatus = status;
        Thread thread = this.mount;
        if (thread == null) {
            tuple2 = Tuple2$.MODULE$.apply((Object)"", (Object)"");
        } else if (thread != null) {
            Thread mount = thread;
            Object object = Predef$.MODULE$.refArrayOps((Object[])mount.getStackTrace());
            tuple2 = Tuple2$.MODULE$.apply((Object)mount.getName(), (Object)((StackTraceElement)ArrayOps$.MODULE$.head$extension(object)).toString());
        } else {
            throw new MatchError((Object)thread);
        }
        Tuple2 tuple22 = tuple2;
        String thread2 = (String)tuple22._1();
        String frame = (String)tuple22._2();
        return WorkerStatus$.MODULE$.apply(this.id, this.running, thread2, frame, this.isBlocked(), this.isStalled(this.getCurrentCycle()), this.executions, this.preemptions, this.completions, this.stolenTasks, this.lostTasks.sum(), this.load(), this.mounts, this.currentCycle, taskStatus);
    }

    private final double registerStats$$anonfun$1() {
        return this.executions;
    }

    private final double registerStats$$anonfun$2() {
        return this.preemptions;
    }

    private final double registerStats$$anonfun$3() {
        return this.completions;
    }

    private final double registerStats$$anonfun$4() {
        return Int$.MODULE$.int2double(this.queue().size());
    }

    private final double registerStats$$anonfun$5() {
        return this.currentCycle;
    }

    private final double registerStats$$anonfun$6() {
        return this.mounts;
    }

    private final double registerStats$$anonfun$7() {
        return this.stolenTasks;
    }

    private final double registerStats$$anonfun$8() {
        return this.lostTasks.sum();
    }

    public static final class WorkerThread
    extends Thread {
        private Worker currentWorker = null;

        public WorkerThread(Runnable init) {
            super(init);
        }

        public Worker currentWorker() {
            return this.currentWorker;
        }

        public void currentWorker_$eq(Worker x$1) {
            this.currentWorker = x$1;
        }
    }
}

