/*
 * Decompiled with CFR 0.152.
 */
package kyo.scheduler;

import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import kyo.scheduler.InternalClock;
import kyo.scheduler.InternalTimer;
import kyo.scheduler.InternalTimer$;
import kyo.scheduler.Scheduler$;
import kyo.scheduler.Scheduler$Config$;
import kyo.scheduler.Scheduler$Status$;
import kyo.scheduler.Task;
import kyo.scheduler.Task$;
import kyo.scheduler.Worker;
import kyo.scheduler.Worker$;
import kyo.scheduler.WorkerStatus;
import kyo.scheduler.package$;
import kyo.scheduler.regulator.Admission;
import kyo.scheduler.regulator.Admission$;
import kyo.scheduler.regulator.Concurrency;
import kyo.scheduler.regulator.Concurrency$;
import kyo.scheduler.util.LoomSupport$;
import kyo.scheduler.util.Top;
import kyo.scheduler.util.XSRandom$;
import kyo.stats.internal.MetricReceiver;
import kyo.stats.internal.MetricReceiver$;
import kyo.stats.internal.UnsafeGauge;
import kyo.stats.internal.UnsafeGauge$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

public final class Scheduler {
    private final Executor workerExecutor;
    private final Config config;
    public final Executor kyo$scheduler$Scheduler$$pool;
    public final InternalClock kyo$scheduler$Scheduler$$clock;
    private final Worker[] workers;
    private final LongAdder flushes;
    private volatile int allocatedWorkers;
    public volatile int kyo$scheduler$Scheduler$$currentWorkers;
    private final long a1;
    private final long a2;
    private final long a3;
    private final long a4;
    private final long a5;
    private final long a6;
    private final long a7;
    public volatile long kyo$scheduler$Scheduler$$cycles;
    private final long b1;
    private final long b2;
    private final long b3;
    private final long b4;
    private final long b5;
    private final long b6;
    private final long b7;
    private final Admission admissionRegulator;
    private final Concurrency concurrencyRegulator;
    private final Top top;
    private final ScheduledFuture<?> cycleTask;
    private final UnsafeGauge gauges;
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(Scheduler$.class.getDeclaredField("defaultTimerExecutor$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(Scheduler$.class.getDeclaredField("defaultClockExecutor$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Scheduler$.class.getDeclaredField("defaultWorkerExecutor$lzy1"));

    public static Scheduler get() {
        return Scheduler$.MODULE$.get();
    }

    public static Executor $lessinit$greater$default$1() {
        return Scheduler$.MODULE$.$lessinit$greater$default$1();
    }

    public static Executor $lessinit$greater$default$2() {
        return Scheduler$.MODULE$.$lessinit$greater$default$2();
    }

    public static ScheduledExecutorService $lessinit$greater$default$3() {
        return Scheduler$.MODULE$.$lessinit$greater$default$3();
    }

    public static Config $lessinit$greater$default$4() {
        return Scheduler$.MODULE$.$lessinit$greater$default$4();
    }

    public Scheduler(Executor workerExecutor, Executor clockExecutor, ScheduledExecutorService timerExecutor, Config config) {
        this.workerExecutor = workerExecutor;
        this.config = config;
        this.kyo$scheduler$Scheduler$$pool = LoomSupport$.MODULE$.tryVirtualize(config.virtualizeWorkers(), workerExecutor);
        this.kyo$scheduler$Scheduler$$clock = new InternalClock(clockExecutor);
        this.workers = new Worker[config.maxWorkers()];
        this.flushes = new LongAdder();
        this.allocatedWorkers = 0;
        this.kyo$scheduler$Scheduler$$currentWorkers = config.coreWorkers();
        this.a1 = 0L;
        this.a2 = 0L;
        this.a3 = 0L;
        this.a4 = 0L;
        this.a5 = 0L;
        this.a6 = 0L;
        this.a7 = 0L;
        this.kyo$scheduler$Scheduler$$cycles = 0L;
        this.b1 = 0L;
        this.b2 = 0L;
        this.b3 = 0L;
        this.b4 = 0L;
        this.b5 = 0L;
        this.b6 = 0L;
        this.b7 = 0L;
        this.ensureWorkers();
        InternalTimer timer = InternalTimer$.MODULE$.apply(timerExecutor);
        this.admissionRegulator = new Admission((Function0<Object>)(Function0 & Serializable)() -> this.loadAvg(), (Function1<Task, BoxedUnit>)(JProcedure1 & Serializable)task -> this.schedule((Task)task), (Function0<Object>)(Function0 & Serializable)() -> System.currentTimeMillis(), timer, Admission$.MODULE$.$lessinit$greater$default$5());
        this.concurrencyRegulator = new Concurrency((Function0<Object>)(Function0 & Serializable)() -> this.loadAvg(), (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable)delta -> this.updateWorkers(delta), (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable)_$1 -> Thread.sleep(Int$.MODULE$.int2long(_$1)), (Function0<Object>)(Function0 & Serializable)() -> System.nanoTime(), timer, Concurrency$.MODULE$.$lessinit$greater$default$6());
        this.top = new Top((Function0<Status>)(Function0 & Serializable)() -> this.status(), config.enableTopJMX(), config.enableTopConsoleMs(), timer);
        this.cycleTask = timerExecutor.scheduleAtFixedRate(() -> this.cycleWorkers(), Int$.MODULE$.int2long(config.timeSliceMs()), Int$.MODULE$.int2long(config.timeSliceMs()), TimeUnit.MILLISECONDS);
        List<String> scope = package$.MODULE$.statsScope((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        MetricReceiver receiver = MetricReceiver$.MODULE$.get();
        this.gauges = UnsafeGauge$.MODULE$.all((Seq<UnsafeGauge>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnsafeGauge[]{receiver.gauge(scope, "current_workers", receiver.gauge$default$3(), receiver.gauge$default$4(), receiver.gauge$default$5(), (Function0<Object>)((Function0 & Serializable)this::$init$$$anonfun$10)), receiver.gauge(scope, "allocated_workers", receiver.gauge$default$3(), receiver.gauge$default$4(), receiver.gauge$default$5(), (Function0<Object>)((Function0 & Serializable)this::$init$$$anonfun$11)), receiver.gauge(scope, "load_avg", receiver.gauge$default$3(), receiver.gauge$default$4(), receiver.gauge$default$5(), (Function0<Object>)((Function0 & Serializable)this::$init$$$anonfun$12)), receiver.gauge(scope, "flushes", receiver.gauge$default$3(), receiver.gauge$default$4(), receiver.gauge$default$5(), (Function0<Object>)((Function0 & Serializable)this::$init$$$anonfun$13))}));
    }

    public long a1() {
        return this.a1;
    }

    public long a2() {
        return this.a2;
    }

    public long a3() {
        return this.a3;
    }

    public long a4() {
        return this.a4;
    }

    public long a5() {
        return this.a5;
    }

    public long a6() {
        return this.a6;
    }

    public long a7() {
        return this.a7;
    }

    public long b1() {
        return this.b1;
    }

    public long b2() {
        return this.b2;
    }

    public long b3() {
        return this.b3;
    }

    public long b4() {
        return this.b4;
    }

    public long b5() {
        return this.b5;
    }

    public long b6() {
        return this.b6;
    }

    public long b7() {
        return this.b7;
    }

    public void schedule(Task task) {
        this.schedule(task, null);
    }

    public boolean reject() {
        return this.admissionRegulator.reject();
    }

    public boolean reject(String key) {
        return this.admissionRegulator.reject(key);
    }

    public boolean reject(int key) {
        return this.admissionRegulator.reject(key);
    }

    public Executor asExecutor() {
        return r -> this.schedule(Task$.MODULE$.apply((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            Scheduler.asExecutor$$anonfun$1$$anonfun$1(r);
            return BoxedUnit.UNIT;
        }));
    }

    public ExecutionContext asExecutionContext() {
        return ExecutionContext$.MODULE$.fromExecutor(this.asExecutor());
    }

    private void schedule(Task task, Worker submitter) {
        long cycles = this.kyo$scheduler$Scheduler$$cycles;
        this.loop$1(submitter, cycles, task, Scheduler.loop$default$1$1());
    }

    private Task steal(Worker thief) {
        long cycles = this.kyo$scheduler$Scheduler$$cycles;
        int currentWorkers = this.kyo$scheduler$Scheduler$$currentWorkers;
        Worker worker = null;
        int maxLoad = 1;
        for (int position = 0; position < currentWorkers; ++position) {
            int load;
            Worker candidate = this.workers[position];
            if (candidate == null || candidate == thief || !candidate.checkAvailability(cycles) || (load = candidate.load()) <= maxLoad) continue;
            maxLoad = load;
            worker = candidate;
        }
        if (worker != null) {
            return worker.stealingBy(thief);
        }
        return null;
    }

    public void flush() {
        Worker worker = Worker$.MODULE$.current();
        if (worker != null) {
            this.flushes.increment();
            worker.drain();
            return;
        }
    }

    public double loadAvg() {
        int currentWorkers = this.kyo$scheduler$Scheduler$$currentWorkers;
        int sum = 0;
        for (int position = 0; position < currentWorkers; ++position) {
            Worker w = this.workers[position];
            if (w == null) continue;
            sum += w.load();
        }
        return (double)sum / (double)currentWorkers;
    }

    public void shutdown() {
        this.cycleTask.cancel(true);
        this.admissionRegulator.stop();
        this.concurrencyRegulator.stop();
        this.gauges.close();
        this.top.close();
    }

    private void updateWorkers(int delta) {
        this.kyo$scheduler$Scheduler$$currentWorkers = Math.max(this.config.minWorkers(), Math.min(this.config.maxWorkers(), this.kyo$scheduler$Scheduler$$currentWorkers + delta));
        this.ensureWorkers();
    }

    private void ensureWorkers() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.allocatedWorkers), this.kyo$scheduler$Scheduler$$currentWorkers).foreach((Function1)(JFunction1.mcVI.sp & Serializable)idx -> {
            this.workers[idx] = new Worker(idx, this){
                private final int idx$2;
                private final /* synthetic */ Scheduler $outer;
                {
                    this.idx$2 = idx$1;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super(idx$1, $outer.kyo$scheduler$Scheduler$$pool, (Function2<Task, Worker, BoxedUnit>)$outer.kyo$scheduler$Scheduler$$_$$anon$superArg$1$1(), (Function1<Worker, Task>)$outer.kyo$scheduler$Scheduler$$_$$anon$superArg$2$1(), $outer.kyo$scheduler$Scheduler$$clock);
                }

                public boolean shouldStop() {
                    return this.idx$2 >= this.$outer.kyo$scheduler$Scheduler$$currentWorkers;
                }

                public long getCurrentCycle() {
                    return this.$outer.kyo$scheduler$Scheduler$$cycles;
                }
            };
            ++this.allocatedWorkers;
        });
    }

    private void cycleWorkers() {
        try {
            long cycles;
            this.kyo$scheduler$Scheduler$$cycles = cycles = this.kyo$scheduler$Scheduler$$cycles + 1L;
            for (int position = 0; position < this.allocatedWorkers; ++position) {
                Worker worker = this.workers[position];
                if (worker == null) continue;
                if (position >= this.kyo$scheduler$Scheduler$$currentWorkers) {
                    worker.drain();
                }
                worker.cycle(cycles);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex)) {
                package$.MODULE$.bug("Worker cyclying has failed.", ex);
            }
            throw throwable;
        }
    }

    public Status status() {
        Tuple2.mcII.sp sp2;
        IndexedSeq activeWorkers = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.kyo$scheduler$Scheduler$$currentWorkers).map((Function1 & Serializable)i -> this.$anonfun$1(BoxesRunTime.unboxToInt((Object)i)));
        IndexedSeq inactiveWorkers = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.kyo$scheduler$Scheduler$$currentWorkers), this.allocatedWorkers).map((Function1 & Serializable)i -> this.$anonfun$2(BoxesRunTime.unboxToInt((Object)i)));
        Executor executor = this.workerExecutor;
        if (executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor exec = (ThreadPoolExecutor)executor;
            sp2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)exec.getActiveCount()), (Object)BoxesRunTime.boxToInteger((int)exec.getPoolSize()));
        } else {
            sp2 = new Tuple2.mcII.sp(-1, -1);
        }
        Tuple2.mcII.sp sp3 = sp2;
        int activeThreads = sp3._1$mcI$sp();
        int totalThreads = sp3._2$mcI$sp();
        return Scheduler$Status$.MODULE$.apply(this.kyo$scheduler$Scheduler$$currentWorkers, this.allocatedWorkers, this.loadAvg(), this.flushes.sum(), activeThreads, totalThreads, (Seq<WorkerStatus>)activeWorkers, (Seq<WorkerStatus>)inactiveWorkers, this.admissionRegulator.status(), this.concurrencyRegulator.status());
    }

    private final double $init$$$anonfun$10() {
        return Int$.MODULE$.int2double(this.kyo$scheduler$Scheduler$$currentWorkers);
    }

    private final double $init$$$anonfun$11() {
        return Int$.MODULE$.int2double(this.allocatedWorkers);
    }

    private final double $init$$$anonfun$12() {
        return this.loadAvg();
    }

    private final double $init$$$anonfun$13() {
        return this.flushes.sum();
    }

    private static final void asExecutor$$anonfun$1$$anonfun$1(Runnable r$1) {
        r$1.run();
    }

    private final void loop$1(Worker submitter$1, long cycles$1, Task task$1, int tries) {
        while (true) {
            Worker worker = null;
            if (submitter$1 == null && tries == 0) {
                worker = Worker$.MODULE$.current();
            }
            if (worker == null) {
                int currentWorkers = this.kyo$scheduler$Scheduler$$currentWorkers;
                int position = XSRandom$.MODULE$.nextInt(currentWorkers);
                int minLoad = Integer.MAX_VALUE;
                for (int stride = Math.min(currentWorkers, this.config.scheduleStride()); stride > 0 && minLoad != 0; --stride) {
                    int l;
                    Worker candidate = this.workers[position];
                    if (candidate != null && candidate != submitter$1 && candidate.checkAvailability(cycles$1) && (l = candidate.load()) < minLoad) {
                        minLoad = l;
                        worker = candidate;
                    }
                    if (++position != currentWorkers) continue;
                    position = 0;
                }
            }
            while (worker == null) {
                worker = this.workers[XSRandom$.MODULE$.nextInt(this.kyo$scheduler$Scheduler$$currentWorkers)];
            }
            if (worker.enqueue(cycles$1, task$1, tries >= this.config.scheduleTries())) break;
            ++tries;
        }
    }

    private static final int loop$default$1$1() {
        return 0;
    }

    public final Function2 kyo$scheduler$Scheduler$$_$$anon$superArg$1$1() {
        return (JProcedure2 & Serializable)(task, submitter) -> this.schedule((Task)task, (Worker)submitter);
    }

    public final Function1 kyo$scheduler$Scheduler$$_$$anon$superArg$2$1() {
        return (Function1 & Serializable)thief -> this.steal((Worker)thief);
    }

    private final WorkerStatus workerStatus$1(int i) {
        Worker worker = this.workers[i];
        if (worker == null) {
            return null;
        }
        Worker worker2 = worker;
        return worker2.status();
    }

    private final /* synthetic */ WorkerStatus $anonfun$1(int i) {
        return this.workerStatus$1(i);
    }

    private final /* synthetic */ WorkerStatus $anonfun$2(int i) {
        return this.workerStatus$1(i);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Config
    implements Product,
    Serializable {
        private final int cores;
        private final int coreWorkers;
        private final int minWorkers;
        private final int maxWorkers;
        private final int scheduleTries;
        private final int scheduleStride;
        private final boolean virtualizeWorkers;
        private final int timeSliceMs;
        private final boolean enableTopJMX;
        private final int enableTopConsoleMs;

        public static Config apply(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, int n7, boolean bl2, int n8) {
            return Scheduler$Config$.MODULE$.apply(n, n2, n3, n4, n5, n6, bl, n7, bl2, n8);
        }

        public static Config default() {
            return Scheduler$Config$.MODULE$.default();
        }

        public static Config fromProduct(Product product) {
            return Scheduler$Config$.MODULE$.fromProduct(product);
        }

        public static Config unapply(Config config) {
            return Scheduler$Config$.MODULE$.unapply(config);
        }

        public Config(int cores, int coreWorkers, int minWorkers, int maxWorkers, int scheduleTries, int scheduleStride, boolean virtualizeWorkers, int timeSliceMs, boolean enableTopJMX, int enableTopConsoleMs) {
            this.cores = cores;
            this.coreWorkers = coreWorkers;
            this.minWorkers = minWorkers;
            this.maxWorkers = maxWorkers;
            this.scheduleTries = scheduleTries;
            this.scheduleStride = scheduleStride;
            this.virtualizeWorkers = virtualizeWorkers;
            this.timeSliceMs = timeSliceMs;
            this.enableTopJMX = enableTopJMX;
            this.enableTopConsoleMs = enableTopConsoleMs;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.cores());
            n = Statics.mix((int)n, (int)this.coreWorkers());
            n = Statics.mix((int)n, (int)this.minWorkers());
            n = Statics.mix((int)n, (int)this.maxWorkers());
            n = Statics.mix((int)n, (int)this.scheduleTries());
            n = Statics.mix((int)n, (int)this.scheduleStride());
            n = Statics.mix((int)n, (int)(this.virtualizeWorkers() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)this.timeSliceMs());
            n = Statics.mix((int)n, (int)(this.enableTopJMX() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)this.enableTopConsoleMs());
            return Statics.finalizeHash((int)n, (int)10);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Config)) return false;
            Config config = (Config)object;
            if (this.cores() != config.cores()) return false;
            if (this.coreWorkers() != config.coreWorkers()) return false;
            if (this.minWorkers() != config.minWorkers()) return false;
            if (this.maxWorkers() != config.maxWorkers()) return false;
            if (this.scheduleTries() != config.scheduleTries()) return false;
            if (this.scheduleStride() != config.scheduleStride()) return false;
            if (this.virtualizeWorkers() != config.virtualizeWorkers()) return false;
            if (this.timeSliceMs() != config.timeSliceMs()) return false;
            if (this.enableTopJMX() != config.enableTopJMX()) return false;
            if (this.enableTopConsoleMs() != config.enableTopConsoleMs()) return false;
            if (!config.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Config;
        }

        public int productArity() {
            return 10;
        }

        public String productPrefix() {
            return "Config";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this._4());
                }
                case 4: {
                    return BoxesRunTime.boxToInteger((int)this._5());
                }
                case 5: {
                    return BoxesRunTime.boxToInteger((int)this._6());
                }
                case 6: {
                    return BoxesRunTime.boxToBoolean((boolean)this._7());
                }
                case 7: {
                    return BoxesRunTime.boxToInteger((int)this._8());
                }
                case 8: {
                    return BoxesRunTime.boxToBoolean((boolean)this._9());
                }
                case 9: {
                    return BoxesRunTime.boxToInteger((int)this._10());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "cores";
                }
                case 1: {
                    return "coreWorkers";
                }
                case 2: {
                    return "minWorkers";
                }
                case 3: {
                    return "maxWorkers";
                }
                case 4: {
                    return "scheduleTries";
                }
                case 5: {
                    return "scheduleStride";
                }
                case 6: {
                    return "virtualizeWorkers";
                }
                case 7: {
                    return "timeSliceMs";
                }
                case 8: {
                    return "enableTopJMX";
                }
                case 9: {
                    return "enableTopConsoleMs";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int cores() {
            return this.cores;
        }

        public int coreWorkers() {
            return this.coreWorkers;
        }

        public int minWorkers() {
            return this.minWorkers;
        }

        public int maxWorkers() {
            return this.maxWorkers;
        }

        public int scheduleTries() {
            return this.scheduleTries;
        }

        public int scheduleStride() {
            return this.scheduleStride;
        }

        public boolean virtualizeWorkers() {
            return this.virtualizeWorkers;
        }

        public int timeSliceMs() {
            return this.timeSliceMs;
        }

        public boolean enableTopJMX() {
            return this.enableTopJMX;
        }

        public int enableTopConsoleMs() {
            return this.enableTopConsoleMs;
        }

        public Config copy(int cores, int coreWorkers, int minWorkers, int maxWorkers, int scheduleTries, int scheduleStride, boolean virtualizeWorkers, int timeSliceMs, boolean enableTopJMX, int enableTopConsoleMs) {
            return new Config(cores, coreWorkers, minWorkers, maxWorkers, scheduleTries, scheduleStride, virtualizeWorkers, timeSliceMs, enableTopJMX, enableTopConsoleMs);
        }

        public int copy$default$1() {
            return this.cores();
        }

        public int copy$default$2() {
            return this.coreWorkers();
        }

        public int copy$default$3() {
            return this.minWorkers();
        }

        public int copy$default$4() {
            return this.maxWorkers();
        }

        public int copy$default$5() {
            return this.scheduleTries();
        }

        public int copy$default$6() {
            return this.scheduleStride();
        }

        public boolean copy$default$7() {
            return this.virtualizeWorkers();
        }

        public int copy$default$8() {
            return this.timeSliceMs();
        }

        public boolean copy$default$9() {
            return this.enableTopJMX();
        }

        public int copy$default$10() {
            return this.enableTopConsoleMs();
        }

        public int _1() {
            return this.cores();
        }

        public int _2() {
            return this.coreWorkers();
        }

        public int _3() {
            return this.minWorkers();
        }

        public int _4() {
            return this.maxWorkers();
        }

        public int _5() {
            return this.scheduleTries();
        }

        public int _6() {
            return this.scheduleStride();
        }

        public boolean _7() {
            return this.virtualizeWorkers();
        }

        public int _8() {
            return this.timeSliceMs();
        }

        public boolean _9() {
            return this.enableTopJMX();
        }

        public int _10() {
            return this.enableTopConsoleMs();
        }
    }

    public static class Status
    implements Product,
    Serializable {
        private final int currentWorkers;
        private final int allocatedWorkers;
        private final double loadAvg;
        private final long flushes;
        private final int activeThreads;
        private final int totalThreads;
        private final Seq<WorkerStatus> activeWorkers;
        private final Seq<WorkerStatus> inactiveWorkers;
        private final Admission.AdmissionStatus admission;
        private final Concurrency.AdmissionStatus concurrency;

        public static Status apply(int n, int n2, double d, long l, int n3, int n4, Seq<WorkerStatus> seq, Seq<WorkerStatus> seq2, Admission.AdmissionStatus admissionStatus, Concurrency.AdmissionStatus admissionStatus2) {
            return Scheduler$Status$.MODULE$.apply(n, n2, d, l, n3, n4, seq, seq2, admissionStatus, admissionStatus2);
        }

        public static Status fromProduct(Product product) {
            return Scheduler$Status$.MODULE$.fromProduct(product);
        }

        public static Status unapply(Status status) {
            return Scheduler$Status$.MODULE$.unapply(status);
        }

        public Status(int currentWorkers, int allocatedWorkers, double loadAvg, long flushes, int activeThreads, int totalThreads, Seq<WorkerStatus> activeWorkers, Seq<WorkerStatus> inactiveWorkers, Admission.AdmissionStatus admission, Concurrency.AdmissionStatus concurrency) {
            this.currentWorkers = currentWorkers;
            this.allocatedWorkers = allocatedWorkers;
            this.loadAvg = loadAvg;
            this.flushes = flushes;
            this.activeThreads = activeThreads;
            this.totalThreads = totalThreads;
            this.activeWorkers = activeWorkers;
            this.inactiveWorkers = inactiveWorkers;
            this.admission = admission;
            this.concurrency = concurrency;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.currentWorkers());
            n = Statics.mix((int)n, (int)this.allocatedWorkers());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.loadAvg()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.flushes()));
            n = Statics.mix((int)n, (int)this.activeThreads());
            n = Statics.mix((int)n, (int)this.totalThreads());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.activeWorkers()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.inactiveWorkers()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.admission()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.concurrency()));
            return Statics.finalizeHash((int)n, (int)10);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Status)) return false;
            Status status = (Status)object;
            if (this.currentWorkers() != status.currentWorkers()) return false;
            if (this.allocatedWorkers() != status.allocatedWorkers()) return false;
            if (this.loadAvg() != status.loadAvg()) return false;
            if (this.flushes() != status.flushes()) return false;
            if (this.activeThreads() != status.activeThreads()) return false;
            if (this.totalThreads() != status.totalThreads()) return false;
            Seq<WorkerStatus> seq = this.activeWorkers();
            Seq<WorkerStatus> seq2 = status.activeWorkers();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Seq<WorkerStatus> seq3 = this.inactiveWorkers();
            Seq<WorkerStatus> seq4 = status.inactiveWorkers();
            if (seq3 == null) {
                if (seq4 != null) {
                    return false;
                }
            } else if (!seq3.equals(seq4)) return false;
            Admission.AdmissionStatus admissionStatus = this.admission();
            Admission.AdmissionStatus admissionStatus2 = status.admission();
            if (admissionStatus == null) {
                if (admissionStatus2 != null) {
                    return false;
                }
            } else if (!((Object)admissionStatus).equals(admissionStatus2)) return false;
            Concurrency.AdmissionStatus admissionStatus3 = this.concurrency();
            Concurrency.AdmissionStatus admissionStatus4 = status.concurrency();
            if (admissionStatus3 == null) {
                if (admissionStatus4 != null) {
                    return false;
                }
            } else if (!((Object)admissionStatus3).equals(admissionStatus4)) return false;
            if (!status.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Status;
        }

        public int productArity() {
            return 10;
        }

        public String productPrefix() {
            return "Status";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToDouble((double)this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToLong((long)this._4());
                }
                case 4: {
                    return BoxesRunTime.boxToInteger((int)this._5());
                }
                case 5: {
                    return BoxesRunTime.boxToInteger((int)this._6());
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return this._8();
                }
                case 8: {
                    return this._9();
                }
                case 9: {
                    return this._10();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "currentWorkers";
                }
                case 1: {
                    return "allocatedWorkers";
                }
                case 2: {
                    return "loadAvg";
                }
                case 3: {
                    return "flushes";
                }
                case 4: {
                    return "activeThreads";
                }
                case 5: {
                    return "totalThreads";
                }
                case 6: {
                    return "activeWorkers";
                }
                case 7: {
                    return "inactiveWorkers";
                }
                case 8: {
                    return "admission";
                }
                case 9: {
                    return "concurrency";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int currentWorkers() {
            return this.currentWorkers;
        }

        public int allocatedWorkers() {
            return this.allocatedWorkers;
        }

        public double loadAvg() {
            return this.loadAvg;
        }

        public long flushes() {
            return this.flushes;
        }

        public int activeThreads() {
            return this.activeThreads;
        }

        public int totalThreads() {
            return this.totalThreads;
        }

        public Seq<WorkerStatus> activeWorkers() {
            return this.activeWorkers;
        }

        public Seq<WorkerStatus> inactiveWorkers() {
            return this.inactiveWorkers;
        }

        public Admission.AdmissionStatus admission() {
            return this.admission;
        }

        public Concurrency.AdmissionStatus concurrency() {
            return this.concurrency;
        }

        private Seq<WorkerStatus> delta(Seq<WorkerStatus> a, Seq<WorkerStatus> b) {
            return (Seq)((IterableOps)a.zipAll(b, null, null)).map(Scheduler$::kyo$scheduler$Scheduler$Status$$_$delta$$anonfun$1);
        }

        public Status $minus(Status other) {
            return Scheduler$Status$.MODULE$.apply(this.currentWorkers(), this.allocatedWorkers(), this.loadAvg(), this.flushes() - other.flushes(), this.activeThreads(), this.totalThreads(), this.delta(this.activeWorkers(), other.activeWorkers()), this.delta(this.inactiveWorkers(), other.inactiveWorkers()), this.admission().$minus(other.admission()), this.concurrency().$minus(other.concurrency()));
        }

        public Status copy(int currentWorkers, int allocatedWorkers, double loadAvg, long flushes, int activeThreads, int totalThreads, Seq<WorkerStatus> activeWorkers, Seq<WorkerStatus> inactiveWorkers, Admission.AdmissionStatus admission, Concurrency.AdmissionStatus concurrency) {
            return new Status(currentWorkers, allocatedWorkers, loadAvg, flushes, activeThreads, totalThreads, activeWorkers, inactiveWorkers, admission, concurrency);
        }

        public int copy$default$1() {
            return this.currentWorkers();
        }

        public int copy$default$2() {
            return this.allocatedWorkers();
        }

        public double copy$default$3() {
            return this.loadAvg();
        }

        public long copy$default$4() {
            return this.flushes();
        }

        public int copy$default$5() {
            return this.activeThreads();
        }

        public int copy$default$6() {
            return this.totalThreads();
        }

        public Seq<WorkerStatus> copy$default$7() {
            return this.activeWorkers();
        }

        public Seq<WorkerStatus> copy$default$8() {
            return this.inactiveWorkers();
        }

        public Admission.AdmissionStatus copy$default$9() {
            return this.admission();
        }

        public Concurrency.AdmissionStatus copy$default$10() {
            return this.concurrency();
        }

        public int _1() {
            return this.currentWorkers();
        }

        public int _2() {
            return this.allocatedWorkers();
        }

        public double _3() {
            return this.loadAvg();
        }

        public long _4() {
            return this.flushes();
        }

        public int _5() {
            return this.activeThreads();
        }

        public int _6() {
            return this.totalThreads();
        }

        public Seq<WorkerStatus> _7() {
            return this.activeWorkers();
        }

        public Seq<WorkerStatus> _8() {
            return this.inactiveWorkers();
        }

        public Admission.AdmissionStatus _9() {
            return this.admission();
        }

        public Concurrency.AdmissionStatus _10() {
            return this.concurrency();
        }
    }
}

