/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.scanner;

import io.gatling.internal.asm.ClassReader;
import io.gatling.internal.asm.ClassVisitor;
import io.gatling.internal.asm.tree.ClassNode;
import io.gatling.scanner.HighestJavaVersionClass;
import io.gatling.scanner.JavaClass;
import io.gatling.scanner.SimulationScanResult;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class SimulationScanner {
    private static final String MODULE_INFO_NAME = "module-info";
    private static final String JAR_ENTRY_CLASS_SUFFIX = ".class";
    private static final byte[] JAVA_CLASS_MAGIC_BYTES = BigInteger.valueOf(-889275714L).toByteArray();
    private static final String ROOT_CLASS_NAME = "java/lang/Object";
    private static final List<String> SIMULATION_CLASSES = List.of("io/gatling/javaapi/core/Simulation", "io/gatling/core/scenario/Simulation");

    private static Optional<byte[]> bytesFromJarEntry(JarFile jarFile, JarEntry jarEntry) throws IOException {
        if (jarEntry.getName().endsWith(JAR_ENTRY_CLASS_SUFFIX)) {
            return Optional.of(jarFile.getInputStream(jarEntry).readAllBytes());
        }
        return Optional.empty();
    }

    private static boolean checkJavaClassMagicBytes(byte[] byArray) {
        if (byArray.length < JAVA_CLASS_MAGIC_BYTES.length) {
            return false;
        }
        for (int i = 0; i < JAVA_CLASS_MAGIC_BYTES.length; ++i) {
            if (byArray[i] == JAVA_CLASS_MAGIC_BYTES[i]) continue;
            return false;
        }
        return true;
    }

    private static Optional<ClassNode> classNodeFromBytes(byte[] byArray) {
        if (SimulationScanner.checkJavaClassMagicBytes(byArray)) {
            ClassReader classReader = new ClassReader(byArray);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 1);
            return Optional.of(classNode);
        }
        return Optional.empty();
    }

    private static Optional<JavaClass> javaClassFromBytes(byte[] byArray) {
        return SimulationScanner.classNodeFromBytes(byArray).filter(classNode -> !classNode.name.equals(MODULE_INFO_NAME) && classNode.superName != null && !classNode.superName.equals(ROOT_CLASS_NAME)).map(JavaClass::new);
    }

    private static List<JavaClass> javaClasses(List<JarFile> list, List<Path> list2) throws IOException {
        Object object;
        ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>();
        for (Path object2 : list2) {
            object = Files.readAllBytes(object2);
            SimulationScanner.javaClassFromBytes((byte[])object).ifPresent(arrayList::add);
        }
        for (JarFile jarFile : list) {
            object = jarFile.entries();
            while (object.hasMoreElements()) {
                Optional<byte[]> optional = SimulationScanner.bytesFromJarEntry(jarFile, (JarEntry)object.nextElement());
                optional.flatMap(SimulationScanner::javaClassFromBytes).ifPresent(arrayList::add);
            }
        }
        return arrayList;
    }

    private static boolean isAncestorSimulation(JavaClass javaClass2, Map<String, JavaClass> map) {
        return SIMULATION_CLASSES.contains(javaClass2.parentName) || Optional.ofNullable(map.get(javaClass2.parentName)).map(javaClass -> SimulationScanner.isAncestorSimulation(javaClass, map)).orElse(false) != false;
    }

    private static List<Path> collectClassFiles(List<File> list) throws IOException {
        ArrayList<Path> arrayList = new ArrayList<Path>();
        for (File file : list) {
            if (!file.isDirectory()) continue;
            Stream<Path> stream = Files.walk(file.toPath(), new FileVisitOption[0]);
            try {
                stream.forEach(path -> {
                    if (Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith(JAR_ENTRY_CLASS_SUFFIX)) {
                        arrayList.add((Path)path);
                    }
                });
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimulationScanResult scan(List<File> list, List<File> list2) throws IOException {
        List<Path> list3 = SimulationScanner.collectClassFiles(list2);
        ArrayList<JarFile> arrayList = new ArrayList<JarFile>();
        try {
            for (File object2 : list) {
                arrayList.add(new JarFile(object2));
            }
            List<JavaClass> list4 = SimulationScanner.javaClasses(arrayList, list3);
            HighestJavaVersionClass highestJavaVersionClass = list4.stream().max(Comparator.comparing(javaClass -> javaClass.javaVersion)).map(javaClass -> new HighestJavaVersionClass(javaClass.fullyQualifiedName(), javaClass.javaVersion)).orElse(null);
            Map map = list4.stream().collect(Collectors.toMap(javaClass -> javaClass.name, Function.identity()));
            List<String> list5 = list4.stream().filter(javaClass -> javaClass.concrete && SimulationScanner.isAncestorSimulation(javaClass, map)).map(JavaClass::fullyQualifiedName).sorted().collect(Collectors.toList());
            SimulationScanResult simulationScanResult = new SimulationScanResult(list5, highestJavaVersionClass);
            return simulationScanResult;
        }
        finally {
            for (JarFile jarFile : arrayList) {
                jarFile.close();
            }
        }
    }
}

