/*
 * Decompiled with CFR 0.152.
 */
package io.gardenerframework.fragrans.data.cache.serialize;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.gardenerframework.fragrans.data.cache.serialize.Serializer;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.springframework.lang.Nullable;

public class JsonSerializer<T>
implements Serializer<T> {
    private final ObjectMapper objectMapper;
    private final Class<T> targetType;

    public JsonSerializer(ObjectMapper objectMapper) {
        this(objectMapper, null);
    }

    public JsonSerializer(ObjectMapper objectMapper, @Nullable Class<T> targetType) {
        this.objectMapper = objectMapper;
        this.targetType = targetType == null ? this.getSubclassParameterizedType() : targetType;
    }

    private Class<T> getSubclassParameterizedType() {
        Type superclass = this.getClass().getGenericSuperclass();
        return TypeFactory.rawClass((Type)((ParameterizedType)superclass).getActualTypeArguments()[0]);
    }

    @Override
    public byte[] serialize(T object) {
        try {
            return this.objectMapper.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    @Nullable
    public T deserialize(@Nullable byte[] content) {
        try {
            return (T)(content == null ? null : this.objectMapper.readValue(content, this.targetType));
        }
        catch (IOException e) {
            throw new UnsupportedOperationException(e);
        }
    }
}

