/*
 * Decompiled with CFR 0.152.
 */
package io.gardenerframework.fragrans.data.cache.serialize;

import io.gardenerframework.fragrans.data.cache.serialize.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.springframework.lang.Nullable;

public class JdkSerializer<T>
implements Serializer<T> {
    @Override
    public byte[] serialize(T object) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            new ObjectOutputStream(outputStream).writeObject(object);
            outputStream.flush();
            byte[] result = outputStream.toByteArray();
            outputStream.close();
            return result;
        }
        catch (IOException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    @Nullable
    public T deserialize(@Nullable byte[] content) {
        if (content == null) {
            return null;
        }
        try {
            return (T)new ObjectInputStream(new ByteArrayInputStream(content)).readObject();
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }
}

