/*
 * Decompiled with CFR 0.152.
 */
package io.gardenerframework.fragrans.data.cache.manager;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gardenerframework.fragrans.data.cache.client.CacheClient;
import io.gardenerframework.fragrans.data.cache.client.RedisCacheClient;
import io.gardenerframework.fragrans.data.cache.lock.CacheLock;
import io.gardenerframework.fragrans.data.cache.lock.context.LockContextHolder;
import io.gardenerframework.fragrans.data.cache.manager.BasicCacheManager;
import io.gardenerframework.fragrans.data.cache.manager.log.schema.detail.DigestCacheDetail;
import io.gardenerframework.fragrans.data.cache.serialize.StringSerializer;
import io.gardenerframework.fragrans.log.GenericLoggerStaticAccessor;
import io.gardenerframework.fragrans.log.common.schema.reason.NotFound;
import io.gardenerframework.fragrans.log.common.schema.state.Done;
import io.gardenerframework.fragrans.log.common.schema.verb.Create;
import io.gardenerframework.fragrans.log.common.schema.verb.Process;
import io.gardenerframework.fragrans.log.common.schema.verb.Start;
import io.gardenerframework.fragrans.log.schema.content.AbstractGenericLogContent;
import io.gardenerframework.fragrans.log.schema.content.GenericBasicLogContent;
import io.gardenerframework.fragrans.log.schema.content.GenericOperationLogContent;
import io.gardenerframework.fragrans.log.schema.details.Detail;
import io.gardenerframework.fragrans.log.schema.word.Word;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.TaskScheduler;

public abstract class DataConsistenceCacheManager<T>
extends BasicCacheManager<T> {
    private static final Logger log = LoggerFactory.getLogger(DataConsistenceCacheManager.class);
    private final TaskScheduler taskScheduler;
    private final String setScript;
    private final String setNxScript;
    private final String setExScript;
    private final String updateTtlScript;
    private final String deleteScript;
    private final CacheLock cacheLock;
    private final StringSerializer stringSerializer = new StringSerializer();
    private final Function<String, T> sourceReader;
    private Duration lockTll = Duration.ofSeconds(10L);
    private Duration dataConsistenceTaskDelay = Duration.ofMinutes(1L);

    protected DataConsistenceCacheManager(CacheClient cacheClient, LockContextHolder lockContextHolder, TaskScheduler taskScheduler, Function<String, T> sourceReader) throws IOException {
        this(cacheClient, lockContextHolder, null, taskScheduler, sourceReader);
    }

    protected DataConsistenceCacheManager(CacheClient cacheClient, LockContextHolder lockContextHolder, @Nullable ObjectMapper objectMapper, TaskScheduler taskScheduler, Function<String, T> sourceReader) throws IOException {
        this(cacheClient, lockContextHolder, objectMapper, null, taskScheduler, sourceReader);
    }

    protected DataConsistenceCacheManager(CacheClient cacheClient, LockContextHolder lockContextHolder, @Nullable ObjectMapper objectMapper, @Nullable Class<T> targetType, TaskScheduler taskScheduler, Function<String, T> sourceReader) throws IOException {
        super(cacheClient, objectMapper, targetType);
        this.taskScheduler = taskScheduler;
        this.sourceReader = sourceReader;
        if (this.supportLuaScript()) {
            RedisCacheClient redisCacheClient = (RedisCacheClient)this.getCacheClient();
            this.setScript = redisCacheClient.loadLuaScriptFile("data-cache-core/script/cache-manager/data-consistence-cache-manager/set.lua");
            this.setExScript = redisCacheClient.loadLuaScriptFile("data-cache-core/script/cache-manager/data-consistence-cache-manager/set-ex.lua");
            this.setNxScript = redisCacheClient.loadLuaScriptFile("data-cache-core/script/cache-manager/data-consistence-cache-manager/set-nx.lua");
            this.updateTtlScript = redisCacheClient.loadLuaScriptFile("data-cache-core/script/cache-manager/data-consistence-cache-manager/update-ttl.lua");
            this.deleteScript = redisCacheClient.loadLuaScriptFile("data-cache-core/script/cache-manager/data-consistence-cache-manager/delete.lua");
        } else {
            this.setScript = null;
            this.setNxScript = null;
            this.setExScript = null;
            this.deleteScript = null;
            this.updateTtlScript = null;
        }
        this.enableLogger(log);
        this.cacheLock = new CacheLock(cacheClient, lockContextHolder);
    }

    @Override
    public void set(@Nullable String[] namespaces, String id, @Nullable String suffix, T object, @Nullable Duration ttl) {
        String key = this.composeCacheKey(namespaces, id, suffix);
        String digestKey = this.composeDigestKey(key);
        String digest = Objects.requireNonNull(this.digestObject(object));
        this.cacheLock.lockThenRun(key, this.lockTll, new DataConsistenceTaskTrigger<Object>(() -> {
            if (this.supportLuaScript()) {
                this.executeScript(this.setScript, 2, this.stringSerializer.serialize(key), this.stringSerializer.serialize(digestKey), this.getSerializer().serialize(object), this.stringSerializer.serialize(digest), ttl == null ? null : this.stringSerializer.serialize(String.valueOf(ttl.getSeconds())));
            } else {
                super.set(namespaces, id, suffix, object, ttl);
                this.getCacheClient().set(digestKey, this.stringSerializer.serialize(digest), ttl);
            }
            this.writeCachedLog(log, new DigestCacheDetail(key, ttl, digestKey, digest));
            return null;
        }, namespaces, id, suffix));
    }

    @Override
    public boolean setIfPresents(@Nullable String[] namespaces, String id, @Nullable String suffix, T object, @Nullable Duration ttl) {
        String key = this.composeCacheKey(namespaces, id, suffix);
        String digestKey = this.composeDigestKey(key);
        String digest = Objects.requireNonNull(this.digestObject(object));
        return Boolean.TRUE.equals(this.cacheLock.lockThenRun(key, this.lockTll, new DataConsistenceTaskTrigger<Boolean>(() -> {
            boolean done;
            if (this.supportLuaScript()) {
                done = this.isOk(this.executeScript(this.setExScript, 2, this.stringSerializer.serialize(key), this.stringSerializer.serialize(digestKey), this.getSerializer().serialize(object), this.stringSerializer.serialize(digest), ttl == null ? null : this.stringSerializer.serialize(String.valueOf(ttl.getSeconds()))));
            } else {
                done = super.setIfPresents(namespaces, id, suffix, object, ttl);
                if (done) {
                    this.getCacheClient().set(digestKey, this.stringSerializer.serialize(digest), ttl);
                }
            }
            if (done) {
                this.writeCachedLog(log, new DigestCacheDetail(key, ttl, digestKey, digest));
            }
            return done;
        }, namespaces, id, suffix)));
    }

    @Override
    public boolean setIfNotPresents(@Nullable String[] namespaces, String id, @Nullable String suffix, T object, @Nullable Duration ttl) {
        String key = this.composeCacheKey(namespaces, id, suffix);
        String digestKey = this.composeDigestKey(key);
        String digest = Objects.requireNonNull(this.digestObject(object));
        return Boolean.TRUE.equals(this.cacheLock.lockThenRun(key, this.lockTll, new DataConsistenceTaskTrigger<Boolean>(() -> {
            boolean done;
            if (this.supportLuaScript()) {
                done = this.isOk(this.executeScript(this.setNxScript, 2, this.stringSerializer.serialize(key), this.stringSerializer.serialize(digestKey), this.getSerializer().serialize(object), this.stringSerializer.serialize(digest), ttl == null ? null : this.stringSerializer.serialize(String.valueOf(ttl.getSeconds()))));
            } else {
                done = super.setIfNotPresents(namespaces, id, suffix, object, ttl);
                if (done) {
                    this.getCacheClient().set(digestKey, this.stringSerializer.serialize(digest), ttl);
                }
            }
            if (done) {
                this.writeCachedLog(log, new DigestCacheDetail(key, ttl, digestKey, digest));
            }
            return done;
        }, namespaces, id, suffix)));
    }

    @Override
    public void delete(@Nullable String[] namespaces, String id, @Nullable String suffix) {
        String key = this.composeCacheKey(namespaces, id, suffix);
        String digestKey = this.composeDigestKey(key);
        this.cacheLock.lockThenRun(key, this.lockTll, () -> {
            if (this.supportLuaScript()) {
                this.executeScript(this.deleteScript, 2, this.stringSerializer.serialize(key), this.stringSerializer.serialize(digestKey));
            } else {
                super.delete(namespaces, id, suffix);
                this.getCacheClient().delete(digestKey);
            }
            this.writeCacheDeletedLog(log, new DigestCacheDetail(key, null, digestKey, null));
            return null;
        });
    }

    @Nullable
    public String getDigest(String id) {
        return this.getDigest(this.scanNamespace(), id, this.scanSuffix());
    }

    @Nullable
    public String getDigest(@Nullable String[] namespaces, String id, @Nullable String suffix) {
        String key = this.composeCacheKey(namespaces, id, suffix);
        String digestKey = this.composeDigestKey(key);
        return this.stringSerializer.deserialize(this.getCacheClient().get(digestKey));
    }

    private boolean supportLuaScript() {
        return this.getCacheClient() instanceof RedisCacheClient && ((RedisCacheClient)this.getCacheClient()).supportLuaScript();
    }

    private String composeDigestKey(String cacheKey) {
        return String.format("%s.digest", cacheKey);
    }

    @Nullable
    public String digestRawData(@Nullable byte[] rawData) {
        if (rawData == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
            byte[] digest = messageDigest.digest(rawData);
            BigInteger text = new BigInteger(1, digest);
            return text.toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public void updateTtl(@Nullable String[] namespaces, String id, @Nullable String suffix, Duration ttl) {
        String key = this.composeCacheKey(namespaces, id, suffix);
        String digestKey = this.composeDigestKey(key);
        if (this.supportLuaScript()) {
            this.executeScript(this.updateTtlScript, 2, this.stringSerializer.serialize(key), this.stringSerializer.serialize(digestKey), this.stringSerializer.serialize(String.valueOf(ttl.getSeconds())));
        } else {
            super.updateTtl(namespaces, id, suffix, ttl);
            this.getCacheClient().updateTtl(digestKey, ttl);
        }
    }

    @Nullable
    public String digestObject(@Nullable T object) {
        if (object == null) {
            return null;
        }
        return this.digestRawData(this.getSerializer().serialize(object));
    }

    private byte[] executeScript(String hash, int numberKeys, byte[] ... keysAndArgs) {
        RedisCacheClient redisCacheClient = (RedisCacheClient)this.getCacheClient();
        ArrayList<byte[]> args = new ArrayList<byte[]>(keysAndArgs.length);
        for (byte[] item : keysAndArgs) {
            if (item == null) continue;
            args.add(item);
        }
        return redisCacheClient.executeScript(hash, numberKeys, (byte[][])args.toArray((T[])new byte[0][]));
    }

    private boolean isOk(byte[] scriptResult) {
        if (scriptResult == null) {
            return false;
        }
        return "OK".equals(new String(scriptResult));
    }

    public void setLockTll(Duration lockTll) {
        this.lockTll = lockTll;
    }

    public void setDataConsistenceTaskDelay(Duration dataConsistenceTaskDelay) {
        this.dataConsistenceTaskDelay = dataConsistenceTaskDelay;
    }

    private class DataConsistenceTaskTrigger<R>
    implements Supplier<R> {
        private final Supplier<R> cacheOperation;
        private final String[] namespaces;
        private final String id;
        private final String suffix;

        @Override
        public R get() {
            R r = this.cacheOperation.get();
            String key = DataConsistenceCacheManager.this.composeCacheKey(this.namespaces, this.id, this.suffix);
            String digestKey = DataConsistenceCacheManager.this.composeDigestKey(key);
            if (DataConsistenceCacheManager.this.cacheLock.tryLock(this.composeTaskKey(key), DataConsistenceCacheManager.this.dataConsistenceTaskDelay) != null) {
                Instant eta = Instant.now().plus(DataConsistenceCacheManager.this.dataConsistenceTaskDelay);
                DataConsistenceCacheManager.this.taskScheduler.schedule((Runnable)new DataConsistenceTask(this.namespaces, this.id, this.suffix), eta);
                GenericLoggerStaticAccessor.operationLogger().debug(log, (AbstractGenericLogContent)((GenericOperationLogContent.GenericOperationLogContentBuilder)((GenericOperationLogContent.GenericOperationLogContentBuilder)GenericOperationLogContent.builder().what(DataConsistenceTask.class)).operation((Word)new Create()).state((Word)new Done()).detail((Detail)new DigestCacheDataConsistenceTaskDetail(key, null, digestKey, null, eta))).build(), null);
            }
            return r;
        }

        private String composeTaskKey(String key) {
            return String.format("%s.data-consistence-task", key);
        }

        public DataConsistenceTaskTrigger(Supplier<R> cacheOperation, String[] namespaces, String id, String suffix) {
            this.cacheOperation = cacheOperation;
            this.namespaces = namespaces;
            this.id = id;
            this.suffix = suffix;
        }

        private class DigestCacheDataConsistenceTaskDetail
        extends DigestCacheDetail {
            private final String eta;

            public DigestCacheDataConsistenceTaskDetail(@Nullable String key, Duration ttl, String digestKey, String digest, Instant eta) {
                super(key, ttl, digestKey, digest);
                this.eta = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX").format(Date.from(eta));
            }
        }

        private class DataConsistenceTask
        implements Runnable {
            private final String[] namespaces;
            private final String id;
            private final String suffix;

            @Override
            public void run() {
                String digest;
                String digestFromDatabase;
                String key = DataConsistenceCacheManager.this.composeCacheKey(this.namespaces, this.id, this.suffix);
                String digestKey = DataConsistenceCacheManager.this.composeDigestKey(key);
                GenericLoggerStaticAccessor.operationLogger().debug(log, (AbstractGenericLogContent)((GenericOperationLogContent.GenericOperationLogContentBuilder)((GenericOperationLogContent.GenericOperationLogContentBuilder)GenericOperationLogContent.builder().what(DataConsistenceTask.class)).operation((Word)new Process()).state((Word)new Start()).detail((Detail)new DigestCacheDetail(key, null, digestKey, null))).build(), null);
                Object source = DataConsistenceCacheManager.this.sourceReader.apply(this.id);
                if (source == null) {
                    GenericLoggerStaticAccessor.basicLogger().warn(log, (AbstractGenericLogContent)((GenericBasicLogContent.GenericBasicLogContentBuilder)((GenericBasicLogContent.GenericBasicLogContentBuilder)GenericBasicLogContent.builder().what(DataConsistenceCacheManager.this.getTargetType())).how((Word)new NotFound()).detail((new Detail(){
                        private String id;

                        private Detail id(String id) {
                            this.id = id;
                            return this;
                        }
                    }).id(this.id))).build(), null);
                    DataConsistenceCacheManager.this.delete(this.namespaces, this.id, this.suffix);
                }
                if (!Objects.equals(digestFromDatabase = DataConsistenceCacheManager.this.digestObject(source), digest = DataConsistenceCacheManager.this.stringSerializer.deserialize(DataConsistenceCacheManager.this.getCacheClient().get(digestKey)))) {
                    GenericLoggerStaticAccessor.basicLogger().warn(log, (AbstractGenericLogContent)((GenericBasicLogContent.GenericBasicLogContentBuilder)((GenericBasicLogContent.GenericBasicLogContentBuilder)GenericBasicLogContent.builder().what(DataConsistenceCacheManager.this.getTargetType())).how((Word)new SourceUpdated()).detail((new Detail(){
                        private String id;
                        private String cachedDigest;
                        private String sourceDigest;
                        {
                            this.cachedDigest = digest;
                            this.sourceDigest = digestFromDatabase;
                        }

                        private Detail id(String id) {
                            this.id = id;
                            return this;
                        }
                    }).id(this.id))).build(), null);
                    DataConsistenceCacheManager.this.delete(this.namespaces, this.id, this.suffix);
                }
                GenericLoggerStaticAccessor.operationLogger().debug(log, (AbstractGenericLogContent)((GenericOperationLogContent.GenericOperationLogContentBuilder)((GenericOperationLogContent.GenericOperationLogContentBuilder)GenericOperationLogContent.builder().what(DataConsistenceTask.class)).operation((Word)new Process()).state((Word)new Done()).detail((Detail)new DigestCacheDetail(key, null, digestKey, null))).build(), null);
            }

            public DataConsistenceTask(String[] namespaces, String id, String suffix) {
                this.namespaces = namespaces;
                this.id = id;
                this.suffix = suffix;
            }

            private class SourceUpdated
            implements Word {
                private SourceUpdated() {
                }

                public String toString() {
                    return "\u6570\u636e\u6e90\u5df2\u53d1\u751f\u53d8\u5316";
                }
            }
        }
    }
}

