/*
 * Decompiled with CFR 0.152.
 */
package io.gardenerframework.fragrans.data.cache.manager;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.gardenerframework.fragrans.data.cache.client.CacheClient;
import io.gardenerframework.fragrans.data.cache.log.schema.detail.CacheDetail;
import io.gardenerframework.fragrans.data.cache.manager.annotation.Cached;
import io.gardenerframework.fragrans.data.cache.serialize.ByteSerializer;
import io.gardenerframework.fragrans.data.cache.serialize.DoubleSerializer;
import io.gardenerframework.fragrans.data.cache.serialize.FloatSerializer;
import io.gardenerframework.fragrans.data.cache.serialize.IntegerSerializer;
import io.gardenerframework.fragrans.data.cache.serialize.JdkSerializer;
import io.gardenerframework.fragrans.data.cache.serialize.JsonSerializer;
import io.gardenerframework.fragrans.data.cache.serialize.LongSerializer;
import io.gardenerframework.fragrans.data.cache.serialize.Serializer;
import io.gardenerframework.fragrans.data.cache.serialize.ShortSerializer;
import io.gardenerframework.fragrans.data.cache.serialize.StringSerializer;
import io.gardenerframework.fragrans.log.GenericLoggerMethodTemplate;
import io.gardenerframework.fragrans.log.GenericLoggerStaticAccessor;
import io.gardenerframework.fragrans.log.GenericOperationLogger;
import io.gardenerframework.fragrans.log.common.schema.state.Done;
import io.gardenerframework.fragrans.log.common.schema.verb.Cache;
import io.gardenerframework.fragrans.log.common.schema.verb.Delete;
import io.gardenerframework.fragrans.log.schema.content.AbstractGenericLogContent;
import io.gardenerframework.fragrans.log.schema.content.GenericOperationLogContent;
import io.gardenerframework.fragrans.log.schema.details.Detail;
import io.gardenerframework.fragrans.log.schema.word.Word;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class BasicCacheManager<T> {
    private static final Logger log = LoggerFactory.getLogger(BasicCacheManager.class);
    private final CacheClient cacheClient;
    private final Serializer<T> serializer;
    private final Class<T> targetType;
    private GenericLoggerMethodTemplate<GenericOperationLogContent> loggingMethod;
    private Logger enabledLogger = log;

    protected BasicCacheManager(CacheClient cacheClient) {
        this(cacheClient, null, null);
    }

    protected BasicCacheManager(CacheClient cacheClient, @Nullable ObjectMapper objectMapper) {
        this(cacheClient, objectMapper, null);
    }

    protected BasicCacheManager(CacheClient cacheClient, @Nullable ObjectMapper objectMapper, @Nullable Class<T> targetType) {
        this.cacheClient = cacheClient;
        this.targetType = targetType == null ? this.getSubclassParameterizedType() : targetType;
        this.serializer = this.deduceSerializer(objectMapper);
        this.loggingMethod = (arg_0, arg_1, arg_2) -> ((GenericOperationLogger)GenericLoggerStaticAccessor.operationLogger()).debug(arg_0, arg_1, arg_2);
    }

    public T get(String id) {
        return this.get(this.scanNamespace(), id, this.scanSuffix());
    }

    @Nullable
    public T get(@Nullable String[] namespaces, String id, @Nullable String suffix) {
        return this.serializer.deserialize(this.cacheClient.get(this.composeCacheKey(namespaces, id, suffix)));
    }

    public void set(String id, T object, @Nullable Duration ttl) {
        this.set(this.scanNamespace(), id, this.scanSuffix(), object, ttl);
    }

    public void set(@Nullable String[] namespaces, String id, @Nullable String suffix, T object, @Nullable Duration ttl) {
        String cacheKey = this.composeCacheKey(namespaces, id, suffix);
        this.cacheClient.set(cacheKey, this.serializer.serialize(object), ttl);
        this.writeCachedLog(log, new CacheDetail(cacheKey, ttl));
    }

    public boolean setIfPresents(String id, T object, @Nullable Duration ttl) {
        return this.setIfPresents(this.scanNamespace(), id, this.scanSuffix(), object, ttl);
    }

    public boolean setIfPresents(@Nullable String[] namespaces, String id, @Nullable String suffix, T object, @Nullable Duration ttl) {
        String cacheKey = this.composeCacheKey(namespaces, id, suffix);
        boolean done = this.cacheClient.setIfPresents(cacheKey, this.serializer.serialize(object), ttl);
        if (done) {
            this.writeCachedLog(log, new CacheDetail(cacheKey, ttl));
        }
        return done;
    }

    public boolean setIfNotPresents(String id, T object, @Nullable Duration ttl) {
        return this.setIfNotPresents(this.scanNamespace(), id, this.scanSuffix(), object, ttl);
    }

    public boolean setIfNotPresents(@Nullable String[] namespaces, String id, @Nullable String suffix, T object, @Nullable Duration ttl) {
        String cacheKey = this.composeCacheKey(namespaces, id, suffix);
        boolean done = this.cacheClient.setIfNotPresents(cacheKey, this.serializer.serialize(object), ttl);
        if (done) {
            this.writeCachedLog(log, new CacheDetail(cacheKey, ttl));
        }
        return done;
    }

    public void delete(String id) {
        this.delete(this.scanNamespace(), id, this.scanSuffix());
    }

    public void delete(@Nullable String[] namespaces, String id, @Nullable String suffix) {
        String cacheKey = this.composeCacheKey(namespaces, id, suffix);
        this.cacheClient.delete(this.composeCacheKey(namespaces, id, suffix));
        this.writeCacheDeletedLog(log, new CacheDetail(cacheKey, null));
    }

    public void updateTtl(String id, Duration ttl) {
        this.updateTtl(this.scanNamespace(), id, this.scanSuffix(), ttl);
    }

    public void updateTtl(@Nullable String[] namespaces, String id, @Nullable String suffix, Duration ttl) {
        this.cacheClient.updateTtl(this.composeCacheKey(namespaces, id, suffix), ttl);
    }

    @Nullable
    public Duration ttl(String id) {
        return this.ttl(this.scanNamespace(), id, this.scanSuffix());
    }

    @Nullable
    public Duration ttl(@Nullable String[] namespaces, String id, @Nullable String suffix) {
        return this.cacheClient.ttl(this.composeCacheKey(namespaces, id, suffix));
    }

    @Nullable
    protected String[] scanNamespace() {
        Cached annotation = (Cached)AnnotationUtils.findAnnotation(this.targetType, Cached.class);
        Assert.notNull((Object)annotation, (String)(this.targetType + " must annotated with Cached"));
        return annotation.namespaces();
    }

    protected String scanSuffix() {
        Cached annotation = (Cached)AnnotationUtils.findAnnotation(this.targetType, Cached.class);
        Assert.notNull((Object)annotation, (String)(this.targetType + " must annotated with Cached"));
        return annotation.suffix();
    }

    protected String composeCacheKey(@Nullable String[] namespace, String id, @Nullable String suffix) {
        LinkedList<String> keyElements = new LinkedList<String>();
        if (namespace != null) {
            keyElements.addAll(Arrays.asList(namespace));
        }
        String key = String.format("{%s}%s", id, StringUtils.hasText((String)suffix) ? "." + suffix : "");
        keyElements.add(key);
        return String.join((CharSequence)":", keyElements);
    }

    protected Serializer<T> deduceSerializer(@Nullable ObjectMapper objectMapper) {
        if (this.targetType.equals(String.class)) {
            return new StringSerializer();
        }
        if (this.targetType.equals(Byte.class)) {
            return new ByteSerializer();
        }
        if (this.targetType.equals(Short.class)) {
            return new ShortSerializer();
        }
        if (this.targetType.equals(Integer.class)) {
            return new IntegerSerializer();
        }
        if (this.targetType.equals(Long.class)) {
            return new LongSerializer();
        }
        if (this.targetType.equals(Float.class)) {
            return new FloatSerializer();
        }
        if (this.targetType.equals(Double.class)) {
            return new DoubleSerializer();
        }
        if (objectMapper != null) {
            return new JsonSerializer<T>(objectMapper, this.targetType);
        }
        if (Serializable.class.isAssignableFrom(this.targetType)) {
            return new JdkSerializer();
        }
        throw new UnsupportedOperationException("can not deduce serializer, subclass should override this method");
    }

    protected final Class<T> getSubclassParameterizedType() {
        Type superclass = this.getClass().getGenericSuperclass();
        return TypeFactory.rawClass((Type)((ParameterizedType)superclass).getActualTypeArguments()[0]);
    }

    protected void writeCachedLog(Logger logger, CacheDetail detail) {
        if (logger == this.enabledLogger) {
            this.enabledLogger.getName();
            this.loggingMethod.log(this.enabledLogger, (AbstractGenericLogContent)((GenericOperationLogContent.GenericOperationLogContentBuilder)((GenericOperationLogContent.GenericOperationLogContentBuilder)GenericOperationLogContent.builder().what(this.targetType)).operation((Word)new Cache()).state((Word)new Done()).detail((Detail)detail)).build(), null);
        }
    }

    protected void writeCacheDeletedLog(Logger logger, CacheDetail detail) {
        if (logger == this.enabledLogger) {
            this.loggingMethod.log(this.enabledLogger, (AbstractGenericLogContent)((GenericOperationLogContent.GenericOperationLogContentBuilder)((GenericOperationLogContent.GenericOperationLogContentBuilder)GenericOperationLogContent.builder().what(this.targetType)).operation((Word)new Delete()).state((Word)new Done()).detail((Detail)detail)).build(), null);
        }
    }

    protected void enableLogger(Logger logger) {
        this.enabledLogger = logger;
    }

    protected CacheClient getCacheClient() {
        return this.cacheClient;
    }

    protected Serializer<T> getSerializer() {
        return this.serializer;
    }

    protected Class<T> getTargetType() {
        return this.targetType;
    }

    protected void setLoggingMethod(GenericLoggerMethodTemplate<GenericOperationLogContent> loggingMethod) {
        this.loggingMethod = loggingMethod;
    }
}

