/*
 * Decompiled with CFR 0.152.
 */
package io.gardenerframework.fragrans.data.cache.lock.context;

import io.gardenerframework.fragrans.data.cache.lock.context.LockContext;
import io.gardenerframework.fragrans.data.cache.lock.context.LockContextHolder;
import org.springframework.lang.Nullable;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class ServletRequestLockContextHolder
implements LockContextHolder {
    private String buildRequestAttributeKey(String key) {
        return String.format("%s.%s", ServletRequestLockContextHolder.class.getCanonicalName(), key);
    }

    @Override
    @Nullable
    public LockContext get(String key) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        return requestAttributes == null ? null : (LockContext)requestAttributes.getAttribute(this.buildRequestAttributeKey(key), 0);
    }

    @Override
    public void set(String key, LockContext context) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            requestAttributes.setAttribute(this.buildRequestAttributeKey(key), (Object)context, 0);
        }
    }

    @Override
    public void remove(String key) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            requestAttributes.removeAttribute(this.buildRequestAttributeKey(key), 0);
        }
    }
}

