/*
 * Decompiled with CFR 0.152.
 */
package io.gardenerframework.fragrans.data.cache.lock;

import io.gardenerframework.fragrans.data.cache.client.CacheClient;
import io.gardenerframework.fragrans.data.cache.client.RedisCacheClient;
import io.gardenerframework.fragrans.data.cache.lock.context.LockContext;
import io.gardenerframework.fragrans.data.cache.lock.context.LockContextHolder;
import io.gardenerframework.fragrans.data.cache.lock.log.schema.detail.CacheLockDetail;
import io.gardenerframework.fragrans.data.cache.serialize.StringSerializer;
import io.gardenerframework.fragrans.log.GenericLoggerStaticAccessor;
import io.gardenerframework.fragrans.log.annotation.LogTarget;
import io.gardenerframework.fragrans.log.common.schema.state.Done;
import io.gardenerframework.fragrans.log.common.schema.verb.Lock;
import io.gardenerframework.fragrans.log.common.schema.verb.Release;
import io.gardenerframework.fragrans.log.schema.content.AbstractGenericLogContent;
import io.gardenerframework.fragrans.log.schema.content.GenericOperationLogContent;
import io.gardenerframework.fragrans.log.schema.details.Detail;
import io.gardenerframework.fragrans.log.schema.word.Word;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@LogTarget(value="\u7f13\u5b58\u9501")
public class CacheLock {
    private static final Logger log = LoggerFactory.getLogger(CacheLock.class);
    private final CacheClient cacheClient;
    private final StringSerializer serializer = new StringSerializer();
    private final String releaseLockScript;
    private final LockContextHolder lockContextHolder;

    public CacheLock(CacheClient cacheClient, LockContextHolder lockContextHolder) throws IOException {
        this.cacheClient = cacheClient;
        this.lockContextHolder = lockContextHolder;
        this.releaseLockScript = this.supportLuaScript() ? ((RedisCacheClient)this.cacheClient).loadLuaScriptFile("data-cache-core/script/cache-lock/release-lock.lua") : null;
    }

    protected String composeLockerName() {
        try {
            String hostAddress = InetAddress.getLocalHost().getHostAddress();
            String processId = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
            String threadId = Thread.currentThread().getName();
            return String.format("%s.%s@%s", processId, threadId, hostAddress);
        }
        catch (UnknownHostException exception) {
            throw new UnsupportedOperationException(exception);
        }
    }

    private String composeLockKey(String key) {
        return String.format("%s.lock", key);
    }

    @Nullable
    public LockContext tryLock(String key, Duration ttl) {
        Date expiresAt;
        Assert.notNull((Object)ttl, (String)"tll must not be null");
        String lockerName = this.composeLockerName();
        String lockKey = this.composeLockKey(key);
        LockContext context = this.lockContextHolder.get(lockKey);
        Date date = expiresAt = context == null ? null : context.getExpiresAt();
        if (expiresAt != null && new Date().before(expiresAt)) {
            GenericLoggerStaticAccessor.operationLogger().debug(log, (AbstractGenericLogContent)((GenericOperationLogContent.GenericOperationLogContentBuilder)((GenericOperationLogContent.GenericOperationLogContentBuilder)GenericOperationLogContent.builder().what(CacheLock.class)).operation((Word)new Lock()).state((Word)new Done()).detail((Detail)new CacheLockDetail(lockKey, Duration.between(Instant.now(), expiresAt.toInstant()), lockerName, true))).build(), null);
            return new LockContext(true, expiresAt);
        }
        boolean locked = this.cacheClient.setIfNotPresents(lockKey, this.serializer.serialize(lockerName), ttl);
        if (locked) {
            LockContext lockContext = new LockContext(false, Date.from(Instant.now().plus(ttl)));
            this.lockContextHolder.set(lockKey, lockContext);
            GenericLoggerStaticAccessor.operationLogger().debug(log, (AbstractGenericLogContent)((GenericOperationLogContent.GenericOperationLogContentBuilder)((GenericOperationLogContent.GenericOperationLogContentBuilder)GenericOperationLogContent.builder().what(CacheLock.class)).operation((Word)new Lock()).state((Word)new Done()).detail((Detail)new CacheLockDetail(lockKey, ttl, lockerName, false))).build(), null);
            return lockContext;
        }
        return null;
    }

    public LockContext lock(String key, Duration ttl) {
        LockContext context;
        while ((context = this.tryLock(key, ttl)) == null) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return context;
    }

    public void releaseLock(String key, LockContext context) {
        Assert.notNull((Object)context, (String)"context must not be null");
        String lockKey = this.composeLockKey(key);
        String lockerName = this.composeLockerName();
        if (!context.isReentered()) {
            if (this.supportLuaScript()) {
                ((RedisCacheClient)this.cacheClient).executeScript(this.releaseLockScript, 1, this.serializer.serialize(lockKey), this.serializer.serialize(lockerName));
            } else {
                String lockerNameFromCache = this.serializer.deserialize(this.cacheClient.get(this.composeLockKey(key)));
                if (StringUtils.hasText((String)lockerNameFromCache) && lockerNameFromCache.equals(lockerName)) {
                    this.cacheClient.delete(lockKey);
                }
            }
            this.lockContextHolder.remove(lockKey);
        }
        GenericLoggerStaticAccessor.operationLogger().debug(log, (AbstractGenericLogContent)((GenericOperationLogContent.GenericOperationLogContentBuilder)((GenericOperationLogContent.GenericOperationLogContentBuilder)GenericOperationLogContent.builder().what(CacheLock.class)).operation((Word)new Release()).state((Word)new Done()).detail((Detail)new CacheLockDetail(lockKey, Duration.between(Instant.now(), context.getExpiresAt().toInstant()), lockerName, context.isReentered()))).build(), null);
    }

    @Nullable
    public <T> T lockThenRun(String key, Duration ttl, Supplier<T> callback) {
        return this.lockThenRun(key, ttl, true, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T lockThenRun(String key, Duration ttl, boolean autoRelease, Supplier<T> callback) {
        LockContext context = null;
        try {
            context = this.lock(key, ttl);
            T t = callback.get();
            return t;
        }
        finally {
            if (autoRelease && context != null) {
                this.releaseLock(key, context);
            }
        }
    }

    private boolean supportLuaScript() {
        return this.cacheClient instanceof RedisCacheClient && ((RedisCacheClient)this.cacheClient).supportLuaScript();
    }
}

