/*
 * Decompiled with CFR 0.152.
 */
package io.gardenerframework.fragrans.data.cache.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.lang.Nullable;

public interface RedisOperation {
    default public boolean supportLuaScript() {
        return false;
    }

    default public boolean scriptExists(String scriptHash) {
        throw new UnsupportedOperationException();
    }

    default public String loadLuaScript(String script) {
        throw new UnsupportedOperationException();
    }

    default public String loadLuaScriptFile(String path) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ClassPathResource(path).getInputStream()));
        StringBuilder stringBuffer = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            stringBuffer.append(line);
            stringBuffer.append("\n");
        }
        return this.loadLuaScript(stringBuffer.toString());
    }

    @Nullable
    default public byte[] executeScript(String scriptHash, int numberKeys, byte[] ... keysAndArgs) {
        return this.executeScript(scriptHash, byte[].class, numberKeys, keysAndArgs);
    }

    @Nullable
    default public <T> T executeScript(String scriptHash, Class<T> resultType, int numberKeys, byte[] ... keysAndArgs) {
        throw new UnsupportedOperationException();
    }

    public void hset(String var1, String var2, byte[] var3);

    public boolean hsetnx(String var1, String var2, byte[] var3);

    @Nullable
    public byte[] hget(String var1, String var2);

    public void hdelete(String var1, String var2);
}

