/*
 * Decompiled with CFR 0.152.
 */
package io.gardenerframework.fragrans.api.options.event;

import io.gardenerframework.fragrans.api.options.lifecycle.event.ApiOptionChangedEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.event.EventListener;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
public class ApiOptionsEventHandler
implements ApplicationEventPublisherAware {
    public static final String API_OPTIONS_NOTIFICATION_TOPIC = "api-options";
    private final KafkaTemplate<String, String> kafkaTemplate;
    private ApplicationEventPublisher eventPublisher;

    @KafkaListener(topics={"api-options"})
    public void onApiOptionsNotification(String rawData) throws IOException, ClassNotFoundException {
        ByteArrayInputStream stream = new ByteArrayInputStream(rawData.getBytes(StandardCharsets.UTF_8));
        Object event = new ObjectInputStream(stream).readObject();
        if (event instanceof ApiOptionChangedEvent) {
            this.eventPublisher.publishEvent(event);
        }
    }

    @EventListener
    public void onApiChangedEvent(ApiOptionChangedEvent event) throws IOException {
        if (event.getSource() != ApiOptionChangedEvent.Source.ENDPOINT) {
            return;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ApiOptionChangedEvent notification = new ApiOptionChangedEvent();
        notification.setId(event.getId());
        notification.setOption(null);
        notification.setInstanceId(event.getInstanceId());
        notification.setSource(ApiOptionChangedEvent.Source.NOTIFICATION);
        new ObjectOutputStream(stream).writeObject(notification);
        this.kafkaTemplate.send(API_OPTIONS_NOTIFICATION_TOPIC, (Object)stream.toString());
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    public ApiOptionsEventHandler(KafkaTemplate<String, String> kafkaTemplate) {
        this.kafkaTemplate = kafkaTemplate;
    }
}

