/*
 * Decompiled with CFR 0.152.
 */
package io.gardenerframework.fragrans.api.validation;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gardenerframework.fragrans.api.standard.error.exception.client.BadRequestArgumentException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.validation.Path;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import lombok.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public class ValidationEnhancedObjectMapper {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Validator validator;

    @Nullable
    private <T> Map<String, Object> doValidate(T object) {
        Set violations = this.validator.validate(object, new Class[0]);
        if (!CollectionUtils.isEmpty((Collection)violations)) {
            HashMap<String, Object> details = new HashMap<String, Object>(violations.size());
            violations.forEach(constraintViolation -> {
                Path propertyPath = constraintViolation.getPropertyPath();
                details.put(propertyPath.toString(), constraintViolation.getMessage());
            });
            return details;
        }
        return null;
    }

    @Nullable
    public <S, T> T tryConvert(@NonNull S source, @NotNull Class<T> targetTpe) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        Object t = this.objectMapper.convertValue(source, targetTpe);
        Map<String, Object> violations = this.doValidate(t);
        if (violations != null) {
            return null;
        }
        return (T)t;
    }

    public <S, T> T convert(@NonNull S source, @NotNull Class<T> targetTpe) throws BadRequestArgumentException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        Object t = this.objectMapper.convertValue(source, targetTpe);
        Map<String, Object> violations = this.doValidate(t);
        if (violations != null) {
            throw new BadRequestArgumentException(violations);
        }
        return (T)t;
    }

    public ValidationEnhancedObjectMapper(Validator validator) {
        this.validator = validator;
    }
}

