/*
 * Decompiled with CFR 0.152.
 */
package io.gardenerframework.fragrans.api.validation;

import io.gardenerframework.fragrans.api.advice.engine.EndpointHandlerMethodAdvice;
import io.gardenerframework.fragrans.api.standard.error.exception.client.BadRequestArgumentException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.validation.Constraint;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.validation.Valid;
import javax.validation.Validator;
import javax.validation.executable.ExecutableValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Order(value=-2147483648)
public class HandlerMethodArgumentsValidationEnhanceSupport
implements EndpointHandlerMethodAdvice {
    private static final Logger log = LoggerFactory.getLogger(HandlerMethodArgumentsValidationEnhanceSupport.class);
    private final Validator validator;
    private final Map<String, Boolean> methodCache = new ConcurrentHashMap<String, Boolean>();

    public HandlerMethodArgumentsValidationEnhanceSupport(Validator validator) {
        this.validator = validator instanceof LocalValidatorFactoryBean ? ((LocalValidatorFactoryBean)validator).getValidator() : (validator instanceof SpringValidatorAdapter ? (Validator)validator.unwrap(Validator.class) : validator);
    }

    private String getSignatureCode(Method method) {
        LinkedList<String> elements = new LinkedList<String>();
        elements.add(Modifier.toString(method.getModifiers()));
        elements.add(method.getReturnType().getCanonicalName());
        elements.add(method.getDeclaringClass().getCanonicalName());
        elements.add(method.getName());
        elements.add("(");
        elements.add(Arrays.stream(method.getParameterTypes()).map(Class::getCanonicalName).collect(Collectors.joining(",")));
        elements.add(")");
        return String.join((CharSequence)" ", elements);
    }

    private boolean analyzeSignature(Method method) {
        Annotation[][] allParameterAnnotations = method.getParameterAnnotations();
        boolean isGetMappingEquivalentPresent = false;
        RequestMapping requestMappingAnnotation = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
        if (requestMappingAnnotation != null) {
            isGetMappingEquivalentPresent = Arrays.asList(requestMappingAnnotation.method()).contains(RequestMethod.GET);
        }
        boolean shouldValidateArguments = false;
        for (Annotation[] singleParameterAnnotations : allParameterAnnotations) {
            boolean isPathVariableOrRequestParamPresent = false;
            boolean isValidPresent = false;
            boolean isConstraintAnnotation = false;
            for (Annotation annotation : singleParameterAnnotations) {
                if (annotation instanceof RequestParam || annotation instanceof PathVariable) {
                    isPathVariableOrRequestParamPresent = true;
                }
                if (annotation instanceof Valid) {
                    isValidPresent = true;
                }
                if (!annotation.annotationType().isAnnotationPresent(Constraint.class)) continue;
                isConstraintAnnotation = true;
            }
            if (!isPathVariableOrRequestParamPresent && !isGetMappingEquivalentPresent && !isConstraintAnnotation || !isValidPresent) continue;
            shouldValidateArguments = true;
            break;
        }
        this.methodCache.put(this.getSignatureCode(method), shouldValidateArguments);
        return shouldValidateArguments;
    }

    private Set<ConstraintViolation<Object>> doValidate(Object target, Method method, Object[] arguments) {
        Set result;
        ExecutableValidator executableValidator = this.validator.forExecutables();
        try {
            result = executableValidator.validateParameters(target, method, arguments, new Class[0]);
        }
        catch (IllegalArgumentException ex) {
            method = BridgeMethodResolver.findBridgedMethod((Method)ClassUtils.getMostSpecificMethod((Method)method, target.getClass()));
            result = executableValidator.validateParameters(target, method, arguments, new Class[0]);
        }
        return result;
    }

    private void validateArguments(Object target, Method method, Object[] arguments) {
        Set<ConstraintViolation<Object>> constraintViolations = null;
        try {
            String signatureCode = this.getSignatureCode(method);
            Boolean shouldValidate = this.methodCache.get(signatureCode);
            if (shouldValidate == null) {
                shouldValidate = this.analyzeSignature(method);
            }
            if (!shouldValidate.booleanValue()) {
                if (log.isDebugEnabled()) {
                    log.debug("{} does not need to validate", (Object)signatureCode);
                }
                return;
            }
            constraintViolations = this.doValidate(target, method, arguments);
        }
        catch (Throwable throwable) {
            log.error("Exception caught:", throwable);
            throw new IllegalStateException(throwable);
        }
        if (!CollectionUtils.isEmpty(constraintViolations)) {
            HashMap details = new HashMap(constraintViolations.size());
            constraintViolations.forEach(constraintViolation -> {
                Path propertyPath = constraintViolation.getPropertyPath();
                propertyPath.forEach(node -> {
                    if (ElementKind.PARAMETER.equals((Object)node.getKind())) {
                        details.put(node.getName(), constraintViolation.getMessage());
                    }
                });
            });
            throw new BadRequestArgumentException(details);
        }
    }

    public void before(Object target, Method method, Object[] arguments) throws Exception {
        this.validateArguments(target, method, arguments);
    }
}

