/*
 * Decompiled with CFR 0.152.
 */
package io.gardenerframework.camellia.authentication.infra.challenge.mfa.server.demo.challenge;

import io.gardenerframework.camellia.authentication.common.client.schema.RequestingClient;
import io.gardenerframework.camellia.authentication.infra.challenge.core.ChallengeCooldownManager;
import io.gardenerframework.camellia.authentication.infra.challenge.core.Scenario;
import io.gardenerframework.camellia.authentication.infra.challenge.core.schema.Challenge;
import io.gardenerframework.camellia.authentication.infra.challenge.engine.support.GenericCachedChallengeContextStore;
import io.gardenerframework.camellia.authentication.infra.challenge.mfa.server.MfaAuthenticator;
import io.gardenerframework.camellia.authentication.infra.sms.challenge.AbstractSmsVerificationCodeChallengeResponseService;
import io.gardenerframework.camellia.authentication.infra.sms.challenge.client.SmsVerificationCodeClient;
import io.gardenerframework.camellia.authentication.infra.sms.challenge.schema.SmsVerificationCodeChallengeContext;
import io.gardenerframework.camellia.authentication.infra.sms.challenge.schema.SmsVerificationCodeChallengeRequest;
import java.sql.Date;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import javax.validation.constraints.NotBlank;
import lombok.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class SmsDemoMfaAuthenticator
extends AbstractSmsVerificationCodeChallengeResponseService<SmsVerificationCodeChallengeRequest, Challenge, SmsVerificationCodeChallengeContext>
implements MfaAuthenticator<SmsVerificationCodeChallengeRequest, Challenge, SmsVerificationCodeChallengeContext> {
    protected SmsDemoMfaAuthenticator(@NonNull ChallengeCooldownManager challengeCooldownManager, @NonNull GenericCachedChallengeContextStore challengeContextStore, @NonNull SmsVerificationCodeClient smsVerificationCodeClient) {
        super(challengeCooldownManager, challengeContextStore.migrateType(), smsVerificationCodeClient);
        if (challengeCooldownManager == null) {
            throw new NullPointerException("challengeCooldownManager is marked non-null but is null");
        }
        if (challengeContextStore == null) {
            throw new NullPointerException("challengeContextStore is marked non-null but is null");
        }
        if (smsVerificationCodeClient == null) {
            throw new NullPointerException("smsVerificationCodeClient is marked non-null but is null");
        }
    }

    protected Challenge createSmsVerificationChallenge(@Nullable RequestingClient client, @NonNull Class<? extends Scenario> scenario, @NonNull SmsVerificationCodeChallengeRequest request, @NonNull Map<String, Object> payload) {
        if (scenario == null) {
            throw new NullPointerException("scenario is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        return Challenge.builder().id(UUID.randomUUID().toString()).expiryTime(Date.from(Instant.now().plus(Duration.ofMinutes(5L)))).build();
    }

    @NonNull
    protected SmsVerificationCodeChallengeContext createSmsVerificationChallengeContext(@Nullable RequestingClient client, @NonNull Class<? extends Scenario> scenario, @NonNull SmsVerificationCodeChallengeRequest request, @NonNull Challenge challenge, @NonNull Map<String, Object> payload) {
        if (scenario == null) {
            throw new NullPointerException("scenario is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (challenge == null) {
            throw new NullPointerException("challenge is marked non-null but is null");
        }
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        return new SmsVerificationCodeChallengeContext();
    }

    public static class MobilePhoneNumber {
        @NotBlank
        private String mobilePhoneNumber;

        public String getMobilePhoneNumber() {
            return this.mobilePhoneNumber;
        }

        public void setMobilePhoneNumber(String mobilePhoneNumber) {
            this.mobilePhoneNumber = mobilePhoneNumber;
        }
    }
}

