package ru.foodtechlab.lib.auth.interation.restapi.feign.accessToken.impl;

import com.rcore.domain.commons.port.dto.SearchResult;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.integration.core.token.accessToken.AccessTokenServiceFacade;
import ru.foodtechlab.lib.auth.interation.restapi.feign.accessToken.FeignAccessTokenServiceClient;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.AccessTokenFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.DeactivateByCredentialRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.DecodeTokenRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.responses.AccessTokenResponse;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.responses.EncodedTokenResponse;

import java.util.Optional;

@RequiredArgsConstructor
@Component
public class FeignHTTPAccessTokenFacade implements AccessTokenServiceFacade {

    private final FeignAccessTokenServiceClient httpClient;

    @Override
    public SearchResult<AccessTokenResponse> find(AccessTokenFiltersRequest request) {
        return httpClient.find(request).getResult();
    }

    @Override
    public Optional<AccessTokenResponse> findById(String id) {
        return Optional.ofNullable(httpClient.findById(id).getResult());
    }

    @Override
    public AccessTokenResponse decode(DecodeTokenRequest request) {
        return httpClient.decodeJwt(request).getResult();
    }

    @Override
    public EncodedTokenResponse encode(String id) {
        return httpClient.encodeToJwt(id).getResult();
    }

    @Override
    public void expireByStatus(String id) {
        httpClient.expireByStatus(id);
    }

    @Override
    public void deactivateByCredentialId(String credentialId) {
        httpClient.deactivateByCredential(new DeactivateByCredentialRequest(credentialId));
    }

    @Override
    public void expireByTime(String id) {
        httpClient.expireByTime(id);
    }
}
