package ru.foodtechlab.lib.auth.interation.restapi.feign.accessToken;

import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import io.foodtechlab.exceptionhandler.core.Error;
import io.foodtechlab.exceptionhandler.core.ErrorApiResponse;
import ru.foodtechlab.lib.auth.integration.core.AccessTokenService;
import ru.foodtechlab.lib.auth.integration.core.token.accessToken.exception.AccessTokenNotFoundException;
import ru.foodtechlab.lib.auth.integration.core.token.accessToken.exception.AccessTokenServiceException;
import ru.foodtechlab.lib.auth.integration.restapi.feign.commons.AuthorizationErrorDecoder;

@Slf4j
public class FeignAccessTokenServiceErrorDecoder extends AuthorizationErrorDecoder {

    public FeignAccessTokenServiceErrorDecoder(ObjectMapper mapper, AccessTokenService accessTokenService) {
        super(mapper, accessTokenService);
    }

    @SneakyThrows
    @Override
    public Exception decode(ErrorApiResponse<Error> errorApiResponse) {
        if (errorApiResponse.getErrors().size() > 0) {
            String detail = errorApiResponse.getErrors().get(0).getDetails().toLowerCase();

            if (detail.contains("not found"))
                return new AccessTokenNotFoundException(errorApiResponse);
        }
        return new AccessTokenServiceException(errorApiResponse);
    }
}
