package ru.foodtechlab.lib.auth.integration.proxy.api.credential.v1.controllers;

import com.rcore.rest.api.commons.response.SuccessApiResponse;
import lombok.RequiredArgsConstructor;
import ru.foodtechlab.lib.auth.integration.core.credential.CredentialServiceFacade;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.requests.InitCredentialRequest;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.responses.CredentialResponse;
import ru.foodtechlab.lib.auth.service.facade.credential.resources.InitCredentialResource;

@RequiredArgsConstructor
public class InitCredentialProxyApiController implements InitCredentialResource {

    protected final CredentialServiceFacade credentialServiceFacade;

    @Override
    public SuccessApiResponse<CredentialResponse> init(InitCredentialRequest request) {
        return SuccessApiResponse.of(credentialServiceFacade.init(request));
    }

    @Override
    public SuccessApiResponse<Boolean> checkInitAvailable() {
        return SuccessApiResponse.of(credentialServiceFacade.checkInitAvailable());
    }
}
