package ru.foodtechlab.lib.auth.integration.core.authorizartion.impl;

import com.rcore.domain.security.model.CredentialDetails;
import com.rcore.domain.security.port.AccessChecker;
import lombok.RequiredArgsConstructor;
import ru.foodtechlab.lib.auth.integration.core.roleAccess.CheckAccessServiceFacade;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.requests.CheckAccessByTokenRequest;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.responses.RoleAccessResponse;

import java.util.Optional;

@RequiredArgsConstructor
public class AccessCheckerViaAuthService implements AccessChecker {

    private final CheckAccessServiceFacade checkAccessServiceFacade;

    @Override
    public CredentialDetails checkAccessByToken(String token, String requestType, String requestPath, String serviceName) {
        return checkAccessServiceFacade.checkAccess(CheckAccessByTokenRequest.builder()
                .accessToken(token)
                .path(requestPath)
                .method(Optional.ofNullable(requestType).map(RoleAccessResponse.Method::valueOf).orElse(null))
                .serviceName(serviceName)
                .build());
    }

    @Override
    public boolean tokenIsValid(String token) {
        return checkAccessServiceFacade.tokenIsValid(token);
    }
}
