/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.integration.core;

import com.rcore.rest.api.commons.exception.HttpCommunicationException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import ru.foodtechlab.lib.auth.integration.core.AccessTokenService;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.AuthorizationServiceFacade;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.RefreshTokenRequest;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.UsernameAuthorizationRequest;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.responses.BasicAuthorizationResponse;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.responses.TokenPairDTO;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.responses.AuthorizationSessionResponse;

@Service
public class AccessTokenServiceImpl
implements AccessTokenService {
    private static final String ROLE_CODE = "MICROSERVICE";
    private static final String PLATFORM = "spring-boot-app";
    private final String username;
    private final String password;
    private final String serviceName;
    private final AuthorizationServiceFacade authorizationServiceFacade;
    private TokenPairDTO tokenPair = new TokenPairDTO();

    public AccessTokenServiceImpl(@Value(value="${foodtechlab.security.username:t}") String username, @Value(value="${foodtechlab.security.password:t}") String password, @Value(value="${spring.application.name}") String serviceName, AuthorizationServiceFacade authorizationServiceFacade) {
        this.username = username;
        this.password = password;
        this.serviceName = serviceName;
        this.authorizationServiceFacade = authorizationServiceFacade;
    }

    @Override
    public String getAccessToken(String requestPath) {
        if (this.tokenPair.getAccessToken() == null) {
            this.tokenPair = this.tokenPair.getRefreshToken() != null ? this.refreshToken() : this.login();
        }
        return this.tokenPair.getAccessToken();
    }

    private TokenPairDTO refreshToken() {
        try {
            BasicAuthorizationResponse newPair = this.authorizationServiceFacade.refreshToken(RefreshTokenRequest.of((String)this.tokenPair.getRefreshToken()));
            return TokenPairDTO.of((String)newPair.getAccessToken(), (String)newPair.getRefreshToken());
        }
        catch (HttpCommunicationException e) {
            return this.login();
        }
    }

    private TokenPairDTO login() {
        BasicAuthorizationResponse newPair = this.authorizationServiceFacade.usernameAuthorization(((UsernameAuthorizationRequest.UsernameAuthorizationRequestBuilder)((UsernameAuthorizationRequest.UsernameAuthorizationRequestBuilder)((UsernameAuthorizationRequest.UsernameAuthorizationRequestBuilder)((UsernameAuthorizationRequest.UsernameAuthorizationRequestBuilder)((UsernameAuthorizationRequest.UsernameAuthorizationRequestBuilder)UsernameAuthorizationRequest.builder().username(this.username).password(this.password).roleCode(ROLE_CODE)).ip("127.0.0.1")).deviceId(this.serviceName)).applicationDetails(AuthorizationSessionResponse.ApplicationDetails.builder().name(this.serviceName).platform(PLATFORM).build())).isRegistrationAllowed(Boolean.valueOf(false))).build());
        return TokenPairDTO.of((String)newPair.getAccessToken(), (String)newPair.getRefreshToken());
    }

    @Override
    public void clearToken(String requestUrl) {
        this.tokenPair.setAccessToken(null);
    }
}

